<?php

function guidv4($data = null) {
    // Generate 16 bytes (128 bits) of random data or use the data passed into the function.
    $data = $data ?? random_bytes(16);
    assert(strlen($data) == 16);

    // Set version to 0100
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
    // Set bits 6-7 to 10
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);

    // Output the 36 character UUID.
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

function uuid(){ return guidv4(); }

function tmpf() {
    $tmp='/home/efm/public_html/tmp/';
    if (!file_exists('path/to/directory')) { mkdir($tmp, 0777, true); }
    return $tmp.guidv4();
}

function tmpd() {
    $tmp='/home/efm/public_html/tmp/';
    rmdir($tmp);
}

include_once '/home/efm/public_html/assets/php/yaml.php';

function pre($code) { return '<pre>'.$code.'</pre>'; }