builder.v.examples = {};
builder.v.examples.tables = [
    {
         order: 1,
         label: "Company",
         db: "company",
         sections: [
            {
                 order: 1,
                 label: "Name",
                 db: "name",
                 fields: [
                    {
                         row: 0,
                         order: 0,
                         dbLen: 40,
                         htmlWidth: 40,
                         more: 1,
                         label: "Name",
                         db: "name",
                         dbType: "varchar",
                         htmlType: "text"
                    }
                ]
            },
            {
                 order: 2,
                 label: "Contact",
                 db: "contact",
                 fields: [
                    {
                         row: 3,
                         order: 1,
                         label: "Phone",
                         db: "phones",
                         isMulti: 1,
                         fields: [
                            {
                                 row: 1,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Label",
                                 db: "label",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 default: "Mobile"
                            },
                            {
                                 row: 1,
                                 order: 2,
                                 dbLen: 20,
                                 htmlWidth: 20,
                                 label: "Number",
                                 db: "number",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 validate: "phone"
                            }
                        ]
                    }
                ]
            },
            {
                 order: 3,
                 label: "Locations",
                 db: "locations",
                 fields: [
                    {
                         row: 4,
                         order: 1,
                         label: "Addresses",
                         db: "addresses",
                         isMulti: 1,
                         fields: [
                            {
                                 row: 1,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Street",
                                 db: "street",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 2,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Street",
                                 db: "street",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 3,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "City",
                                 db: "city",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 3,
                                 order: 2,
                                 dbLen: 2,
                                 htmlWidth: 2,
                                 label: "State",
                                 db: "state",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 validate: "state"
                            },
                            {
                                 row: 4,
                                 order: 1,
                                 dbLen: 20,
                                 htmlWidth: 20,
                                 label: "Zip",
                                 db: "zip",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 5,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 20,
                                 label: "Country",
                                 db: "country",
                                 dbType: "varchar",
                                 htmlType: "text"
                            }
                        ]
                    }
                ]
            }
        ]
    },
    {
         order: 1,
         label: "People",
         db: "people",
         sections: [
            {
                 order: 1,
                 label: "Name",
                 db: "name",
                 fields: [
                    {
                         row: 0,
                         order: 0,
                         dbLen: 40,
                         htmlWidth: 40,
                         more: 1,
                         label: "company ID",
                         db: "uuid_company",
                         dbType: "varchar",
                         htmlType: "hidden-parent-id"
                    },
                    {
                         row: 1,
                         order: 1,
                         dbLen: 10,
                         htmlWidth: 10,
                         more: 1,
                         label: "Prefix",
                         db: "prefix",
                         dbType: "varchar",
                         htmlType: "list",
                         options: [
                            {
                                 text: "Dr",
                                 save: "Dr"
                            },
                            {
                                 text: "Mr",
                                 save: "Mr"
                            },
                            {
                                 text: "Mrs",
                                 save: "Mrs"
                            },
                            {
                                 text: "Miss",
                                 save: "Miss"
                            }
                        ]
                    },
                    {
                         row: 1,
                         order: 2,
                         required: 1,
                         placeholder: "First",
                         dbLen: 100,
                         htmlWidth: 100,
                         htmlHeight: 0,
                         label: "First",
                         db: "first",
                         dbType: "varchar",
                         htmlType: "text"
                    },
                    {
                         row: 1,
                         order: 3,
                         dbLen: 100,
                         htmlWidth: 100,
                         placeholder: "Last",
                         label: "Last",
                         db: "last",
                         dbType: "varchar",
                         htmlType: "text"
                    },
                    {
                         row: 1,
                         order: 4,
                         dbLen: 10,
                         htmlWidth: 10,
                         more: 1,
                         db: "suffix",
                         label: "Suffix",
                         dbType: "varchar",
                         htmlType: "list",
                         options: [
                            {
                                 text: "Jr",
                                 save: "Jr"
                            }
                        ]
                    },
                    {
                         row: 2,
                         order: 1,
                         dbLen: 200,
                         htmlWidth: 200,
                         label: "Label",
                         db: "label",
                         dbType: "varchar",
                         htmlType: "text"
                    }
                ]
            },
            {
                 order: 2,
                 label: "Contact",
                 db: "contact",
                 fields: [
                    {
                         row: 3,
                         order: 1,
                         label: "Phone",
                         db: "phones",
                         isMulti: 1,
                         fields: [
                            {
                                 row: 1,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Label",
                                 db: "label",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 default: "Mobile"
                            },
                            {
                                 row: 1,
                                 order: 2,
                                 dbLen: 20,
                                 htmlWidth: 20,
                                 label: "Number",
                                 db: "number",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 validate: "phone"
                            }
                        ]
                    },
                    {
                         row: 3,
                         order: 2,
                         label: "Email",
                         db: "email",
                         isMulti: 1,
                         fields: [
                            {
                                 row: 1,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Label",
                                 db: "label",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 default: "Personal"
                            },
                            {
                                 row: 1,
                                 order: 2,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Email",
                                 db: "email",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 validate: "email"
                            }
                        ]
                    }
                ]
            },
            {
                 order: 3,
                 label: "Locations",
                 db: "locations",
                 fields: [
                    {
                         row: 4,
                         order: 1,
                         label: "Addresses",
                         db: "addresses",
                         isMulti: 1,
                         fields: [
                            {
                                 row: 1,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Street",
                                 db: "street",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 2,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "Street",
                                 db: "street",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 3,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 100,
                                 label: "City",
                                 db: "city",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 3,
                                 order: 2,
                                 dbLen: 2,
                                 htmlWidth: 2,
                                 label: "State",
                                 db: "state",
                                 dbType: "varchar",
                                 htmlType: "text",
                                 validate: "state"
                            },
                            {
                                 row: 4,
                                 order: 1,
                                 dbLen: 20,
                                 htmlWidth: 20,
                                 label: "Zip",
                                 db: "zip",
                                 dbType: "varchar",
                                 htmlType: "text"
                            },
                            {
                                 row: 5,
                                 order: 1,
                                 dbLen: 100,
                                 htmlWidth: 20,
                                 label: "Country",
                                 db: "country",
                                 dbType: "varchar",
                                 htmlType: "text"
                            }
                        ]
                    }
                ]
            }
        ]
    }
];