

signature.staffType = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Staff Type',
    fieldprefix: 'staff_type_',
    del: function(i) {
        try {signature.staffType.records[i].staff_type_label = $('#signature_' + i + '_Label').val();} catch (err) { }
        try { $('#label_' + i + '_Label').text(signature.staffType.records[i].staff_type_label); } catch (err) { }
        try {signature.staffType.records[i].staff_type_services = $('#signature_' + i + '_Services').val();} catch (err) { }
        try {signature.staffType.records[i].staff_type_status = $('#signature_' + i + '_Status').val();} catch (err) { }
        try {signature.staffType.records[i].label = signature.staffType.records[i].staff_type_label; } catch (err) { }


        signature.staffType.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.staffType.records.length - 1; iy >= 0; iy--) {
            if (signature.staffType.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.staffType.isLoading && !signature.staffType.list.includes(i)) {
            signature.staffType.list.push(i);
            // console.log(i);
        }
        // signature.staffType.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.staffType.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.staffType.displayweek();
        // signature.staffType.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.staffType.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.staffType.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.staffType.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.staffType.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.staffType.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.staffType.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.staffType.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.staffType.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.staffType.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.staffType.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.staffType.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var i = 0; i < signature.staffType.records.length; i++) {
                if (signature.staffType.records[i][signature.staffType.fieldprefix+'status'] === '1') {
                    if (search.length > 0) {
                        if (signature.staffType.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.staffType.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.staffType.records[i]['label']+'</div>');
                        }
                    } else {
                        $('#selectsomething .items').append('<div class="item" guid="'+signature.staffType.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.staffType.records[i]['label']+'</div>');
                    }
                    // labels.push({'label':signature.staffType.records[i]['label'], 'guid':signature.staffType.records[i]['guid'], });
                }
            }
        } catch(err) {}
        // for (var i = 0; i < labels.length; i++) {}
        if (signature.staffType.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.staffType.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.staffType.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.staffType.doThisWhenDone("autosearch", 200, signature.staffType.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'staffType';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.staffType.varUpdate();';
        } else {
            signature.v.save = 'signature.staffType.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.staffType.isLoading = true;
        


        if (signature.staffType.isChild) {
            var data = {"field_id":"","label":"","guid":signature.staffType.guid(),"staff_type_label":"","staff_type_services":"1","staff_type_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.staffType.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.staffType.records.length === 0) {
            signature.staffType.add();
        } else {
            signature.staffType.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.staffType.update = JSON.stringify(signature.staffType.records);
        // console.log('test');
        // signature.staffType.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.staffType.guid(),"staff_type_label":"","staff_type_services":"1","staff_type_status":"1","action_del":"N"};

        signature.staffType.varUpdate();
        signature.staffType.records.push(data);
        signature.staffType.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.staffType.guid(),"staff_type_label":"","staff_type_services":"1","staff_type_status":"1","action_del":"N"};

        signature.staffType.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.hasFields()) {
                    try {if (signature.staffType.records[i].staff_type_label !== $('#signature_' + i + '_Label').val()){signature.staffType.listAdd(i);} } catch (err) { }
                    try {signature.staffType.records[i].staff_type_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.staffType.records[i].staff_type_label); } catch (err) { }
                    try {if (signature.staffType.records[i].staff_type_services !== $('#signature_' + i + '_Services').val()){signature.staffType.listAdd(i);} } catch (err) { }
                    try {signature.staffType.records[i].staff_type_services = $('#signature_' + i + '_Services').val();} catch (err) { }
                    try {if (signature.staffType.records[i].staff_type_status !== $('#signature_' + i + '_Status').val()){signature.staffType.listAdd(i);} } catch (err) { }
                    try {signature.staffType.records[i].staff_type_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.staffType.records[i].label = signature.staffType.records[i].staff_type_label; } catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.staffType.records.length; i++){
//                 if (signature.staffType.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.staffType.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.staffType.records.length - 1; iy >= 0; iy--) {
                if (signature.staffType.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.staffType.records.length; i++) {
                try {
                    if (signature.staffType.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Label';
                        if ($(item).val().length && $(item).val() !== 'Label') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Services';
                        if ($(item).val().length > 0  && $(item).val() !== 'Services') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.staffType.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.staffType.records);
        var two = signature.staffType.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.staffType.valid()) {
            signature.staffType.varUpdate();
            if (eval(signature.staffType.valid)) {
                if ( signature.staffType.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.staffType.records.length; i++) {
                        try {
                            try {signature.staffType.records[i].staff_type_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.staffType.records[i].staff_type_label); } catch (err) { }
                    try {signature.staffType.records[i].staff_type_services = $('#signature_' + i + '_Services').val();} catch (err) { }
                    try {signature.staffType.records[i].staff_type_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.staffType.records[i].label = signature.staffType.records[i].staff_type_label; } catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.staffType.list.length; i++) {
                        sendThisData.push(signature.staffType.records[signature.staffType.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processStaff_Type.php", $("#form").serialize())
                    $.post("processStaff_Type.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.staffType.send(); }
                            } else {
                                signature.staffType.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.staffType.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.staffType.update = JSON.stringify(signature.staffType.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.staffType.shouldUpdate() ) {
            // signature.staffType.thisweek();
        // }
        // signature.staffType.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.staffType.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.staffType.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.staffType.records.length; i++) {
            try {
                    try {signature.staffType.records[i].staff_type_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.staffType.records[i].staff_type_label); } catch (err) { }
                    try {signature.staffType.records[i].staff_type_services = $('#signature_' + i + '_Services').val();} catch (err) { }
                    try {signature.staffType.records[i].staff_type_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.staffType.records[i].label = signature.staffType.records[i].staff_type_label; } catch (err) { }


                signature.staffType.records[i].action_del = 'N';
            } catch(err) {
                signature.staffType.records[i].action_del = 'N';
            }
        }
        //signature.staffType.records = JSON.parse(signature.v.recover);
        signature.staffType.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.staffType.records.length; i++) {
            if ( $( '#signature_' + i + '_Label' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.staffType.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.staffType.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.staffType.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Label_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Label') }
            if ( $('#'+signature.v.lastID).hasClass('_Services_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Services') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.staffType.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.staffType.varUpdate();
        for (var i = 0; i < signature.staffType.records.length; i++) {
            try {
                if (signature.staffType.records[i].action_del === 'N') {
                    try {signature.staffType.records[i].staff_type_services = $('#signature_' + i + '_Services').val();} catch (err) { }
                    if (signature.staffType.records[i].staff_type_services === '1') {$('#toggle_' + i + '_Services_on').css('display','inline-block');$('#toggle_' + i + '_Services_off').css('display','none');} else {$('#toggle_' + i + '_Services_on').css('display','none');$('#toggle_' + i + '_Services_off').css('display','inline-block');}
                    try {signature.staffType.records[i].staff_type_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.staffType.records[i].staff_type_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.staffType.records[i]['guid'])
        $('#'+lid).text(signature.staffType.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.staffType.records.length; i++) {
                if (signature.staffType.records[i][signature.staffType.fieldprefix+'status'] === '1') {
                    labels.push(signature.staffType.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.staffType.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.staffType.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.staffType.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.staffType.doThisWhenDone("autosearch", 200, signature.staffType.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Label' === id && $('#'+id).val() === 'Label') { $('#'+id).val('') }
        if ('signature_'+idx+'_Services' === id && $('#'+id).val() === 'Services') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.staffType.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, label, services, status) {
            if (typeof i === 'undefined') {
                i = signature.staffType.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof label === 'undefined') { label = ''; }
            if (typeof services === 'undefined') { services = '1'; }
            if (typeof status === 'undefined') { status = '1'; }


            if (label === '') { label = 'Label'; }
            if (services === '') { services = 'Services'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.staffType.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" title="Label">\
                    <div id="label_' + i + '_Label" class="itemLabel label" onclick="signature.staffType.doThisWhenDone(\'field_focus\', 8000, signature.staffType.formBlur);signature.staffType.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Label"> Label: </div>\
                    <div id="eefLabel" class="signatureField">\
                        <input name="Label_' + i + '" type="text" id="signature_' + i + '_Label" class="signaturebox _Label_" value="' + label + '" style="display:none;"  relatedfield="label_' + i + '_Label" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label services" style="display:none;"> Services: </div>\
                    <div id="eefServices_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Services_" onclick="signature.staffType.toggle(\'eefServices_' + i + '_\',\'services\',\'signature_' + i + '_Services\',\'label_' + i + '_Services_\');"><span id="label_' + i + '_Services_" class="togglelabel" style="display:none;">Services</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Services_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Services_off" class="toggleOff">\
                        <input name="Services_' + i + '" type="hidden" id="signature_' + i + '_Services" class="signaturebox _Services_" value="' + services + '">\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.staffType.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.staffType.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.staffType.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.staffType.records.length; i++){

                if (signature.staffType.records[i].action_del === 'N') {
                    if (signature.staffType.isChild) {
                        if (signature.staffType.parent === signature.staffType.records[i][signature.staffType.px]) {
                            signature.staffType.htmlRow(i, signature.staffType.records[i].field_id, signature.staffType.records[i].guid, signature.staffType.records[i].staff_type_label, signature.staffType.records[i].staff_type_services, signature.staffType.records[i].staff_type_status);
                        }

                    } else {
                        signature.staffType.htmlRow(i, signature.staffType.records[i].field_id, signature.staffType.records[i].guid, signature.staffType.records[i].staff_type_label, signature.staffType.records[i].staff_type_services, signature.staffType.records[i].staff_type_status);
                    }
                    
                    // signature.staffType.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.staffType.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.staffType.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.staffType.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.staffType.doThisWhenDone('field_focus', 8000, signature.staffType.formBlur);signature.staffType.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.staffType.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.staffType.sectionlabel+'</div>');
        
        signature.staffType.toggleSwitches();
        signature.staffType.resolveids();
        signature.staffType.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.staffType.runDoThis(myLabel); }, waitforAbout);

        // signature.staffType.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i].action_del === 'N') {
                    if (signature.staffType.records[i][theKey1] === guid) {
                        signature.staffType.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staffType.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i].action_del === 'N') {
                    if (signature.staffType.records[i][theKey1] === search1 && signature.staffType.records[i][theKey2] === search2) {
                        signature.staffType.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staffType.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i].action_del === 'N') {
                    if (signature.staffType.records[i][theKey1] === search1 && signature.staffType.records[i][theKey2] === search2 && signature.staffType.records[i][theKey3] === search3) {
                        signature.staffType.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staffType.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i][theKey1] === search1 && signature.staffType.records[i][theKey2] === search2) {
                    var result = signature.staffType.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.staffType.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i][theKey1] === guid) {
                    var result = signature.staffType.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.staffType.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.staffType.records.length > 0) {

            var keys = Object.keys(signature.staffType.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.staffType.records.length; i++){
                if (signature.staffType.records[i].guid === guid) {
                    var result = signature.staffType.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.staffType.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.category = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Category',
    fieldprefix: 'category_',
    del: function(i) {
        try {signature.category.records[i].category_label = $('#signature_' + i + '_Label').val();} catch (err) { }
        try { $('#label_' + i + '_Label').text(signature.category.records[i].category_label); } catch (err) { }
        try {signature.category.records[i].category_status = $('#signature_' + i + '_Status').val();} catch (err) { }
        try {signature.category.records[i].label = signature.category.records[i].category_label; } catch (err) { }


        signature.category.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.category.records.length - 1; iy >= 0; iy--) {
            if (signature.category.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.category.isLoading && !signature.category.list.includes(i)) {
            signature.category.list.push(i);
            // console.log(i);
        }
        // signature.category.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.category.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.category.displayweek();
        // signature.category.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.category.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.category.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.category.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.category.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.category.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.category.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.category.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.category.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.category.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.category.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.category.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var i = 0; i < signature.category.records.length; i++) {
                if (signature.category.records[i][signature.category.fieldprefix+'status'] === '1') {
                    if (search.length > 0) {
                        if (signature.category.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.category.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.category.records[i]['label']+'</div>');
                        }
                    } else {
                        $('#selectsomething .items').append('<div class="item" guid="'+signature.category.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.category.records[i]['label']+'</div>');
                    }
                    // labels.push({'label':signature.category.records[i]['label'], 'guid':signature.category.records[i]['guid'], });
                }
            }
        } catch(err) {}
        // for (var i = 0; i < labels.length; i++) {}
        if (signature.category.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.category.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.category.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.category.doThisWhenDone("autosearch", 200, signature.category.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'category';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.category.varUpdate();';
        } else {
            signature.v.save = 'signature.category.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.category.isLoading = true;
        


        if (signature.category.isChild) {
            var data = {"field_id":"","label":"","guid":signature.category.guid(),"category_label":"","category_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.category.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.category.records.length === 0) {
            signature.category.add();
        } else {
            signature.category.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.category.update = JSON.stringify(signature.category.records);
        // console.log('test');
        // signature.category.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.category.guid(),"category_label":"","category_status":"1","action_del":"N"};

        signature.category.varUpdate();
        signature.category.records.push(data);
        signature.category.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.category.guid(),"category_label":"","category_status":"1","action_del":"N"};

        signature.category.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.hasFields()) {
                    try {if (signature.category.records[i].category_label !== $('#signature_' + i + '_Label').val()){signature.category.listAdd(i);} } catch (err) { }
                    try {signature.category.records[i].category_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.category.records[i].category_label); } catch (err) { }
                    try {if (signature.category.records[i].category_status !== $('#signature_' + i + '_Status').val()){signature.category.listAdd(i);} } catch (err) { }
                    try {signature.category.records[i].category_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.category.records[i].label = signature.category.records[i].category_label; } catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.category.records.length; i++){
//                 if (signature.category.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.category.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.category.records.length - 1; iy >= 0; iy--) {
                if (signature.category.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.category.records.length; i++) {
                try {
                    if (signature.category.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Label';
                        if ($(item).val().length && $(item).val() !== 'Label') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.category.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.category.records);
        var two = signature.category.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.category.valid()) {
            signature.category.varUpdate();
            if (eval(signature.category.valid)) {
                if ( signature.category.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.category.records.length; i++) {
                        try {
                            try {signature.category.records[i].category_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.category.records[i].category_label); } catch (err) { }
                    try {signature.category.records[i].category_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.category.records[i].label = signature.category.records[i].category_label; } catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.category.list.length; i++) {
                        sendThisData.push(signature.category.records[signature.category.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processCategory.php", $("#form").serialize())
                    $.post("processCategory.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.category.send(); }
                            } else {
                                signature.category.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.category.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.category.update = JSON.stringify(signature.category.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.category.shouldUpdate() ) {
            // signature.category.thisweek();
        // }
        // signature.category.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.category.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.category.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.category.records.length; i++) {
            try {
                    try {signature.category.records[i].category_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.category.records[i].category_label); } catch (err) { }
                    try {signature.category.records[i].category_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.category.records[i].label = signature.category.records[i].category_label; } catch (err) { }


                signature.category.records[i].action_del = 'N';
            } catch(err) {
                signature.category.records[i].action_del = 'N';
            }
        }
        //signature.category.records = JSON.parse(signature.v.recover);
        signature.category.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.category.records.length; i++) {
            if ( $( '#signature_' + i + '_Label' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.category.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.category.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.category.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Label_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Label') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.category.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.category.varUpdate();
        for (var i = 0; i < signature.category.records.length; i++) {
            try {
                if (signature.category.records[i].action_del === 'N') {
                    try {signature.category.records[i].category_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.category.records[i].category_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.category.records[i]['guid'])
        $('#'+lid).text(signature.category.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.category.records.length; i++) {
                if (signature.category.records[i][signature.category.fieldprefix+'status'] === '1') {
                    labels.push(signature.category.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.category.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.category.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.category.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.category.doThisWhenDone("autosearch", 200, signature.category.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Label' === id && $('#'+id).val() === 'Label') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.category.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, label, status) {
            if (typeof i === 'undefined') {
                i = signature.category.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof label === 'undefined') { label = ''; }
            if (typeof status === 'undefined') { status = '1'; }


            if (label === '') { label = 'Label'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.category.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" title="Label">\
                    <div id="label_' + i + '_Label" class="itemLabel label" onclick="signature.category.doThisWhenDone(\'field_focus\', 8000, signature.category.formBlur);signature.category.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Label"> Label: </div>\
                    <div id="eefLabel" class="signatureField">\
                        <input name="Label_' + i + '" type="text" id="signature_' + i + '_Label" class="signaturebox _Label_" value="' + label + '" style="display:none;"  relatedfield="label_' + i + '_Label" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.category.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.category.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.category.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.category.records.length; i++){

                if (signature.category.records[i].action_del === 'N') {
                    if (signature.category.isChild) {
                        if (signature.category.parent === signature.category.records[i][signature.category.px]) {
                            signature.category.htmlRow(i, signature.category.records[i].field_id, signature.category.records[i].guid, signature.category.records[i].category_label, signature.category.records[i].category_status);
                        }

                    } else {
                        signature.category.htmlRow(i, signature.category.records[i].field_id, signature.category.records[i].guid, signature.category.records[i].category_label, signature.category.records[i].category_status);
                    }
                    
                    // signature.category.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.category.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.category.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.category.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.category.doThisWhenDone('field_focus', 8000, signature.category.formBlur);signature.category.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.category.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.category.sectionlabel+'</div>');
        
        signature.category.toggleSwitches();
        signature.category.resolveids();
        signature.category.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.category.runDoThis(myLabel); }, waitforAbout);

        // signature.category.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i].action_del === 'N') {
                    if (signature.category.records[i][theKey1] === guid) {
                        signature.category.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.category.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i].action_del === 'N') {
                    if (signature.category.records[i][theKey1] === search1 && signature.category.records[i][theKey2] === search2) {
                        signature.category.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.category.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i].action_del === 'N') {
                    if (signature.category.records[i][theKey1] === search1 && signature.category.records[i][theKey2] === search2 && signature.category.records[i][theKey3] === search3) {
                        signature.category.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.category.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i][theKey1] === search1 && signature.category.records[i][theKey2] === search2) {
                    var result = signature.category.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.category.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i][theKey1] === guid) {
                    var result = signature.category.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.category.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.category.records.length > 0) {

            var keys = Object.keys(signature.category.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.category.records.length; i++){
                if (signature.category.records[i].guid === guid) {
                    var result = signature.category.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.category.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.staff = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Staff',
    fieldprefix: 'staff_',
    del: function(i) {
        try {signature.staff.records[i].staff_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
        try {signature.staff.records[i].staff_label_first_last = $('#signature_' + i + '_Label_First_Last').val();} catch (err) { }
        try { $('#label_' + i + '_Label_First_Last').text(signature.staff.records[i].staff_label_first_last); } catch (err) { }
        try {signature.staff.records[i].staff_first = $('#signature_' + i + '_First').val();} catch (err) { }
        try { $('#label_' + i + '_First').text(signature.staff.records[i].staff_first); } catch (err) { }
        try {signature.staff.records[i].staff_last = $('#signature_' + i + '_Last').val();} catch (err) { }
        try { $('#label_' + i + '_Last').text(signature.staff.records[i].staff_last); } catch (err) { }
        try {signature.staff.records[i].staff_status = $('#signature_' + i + '_Status').val();} catch (err) { }
        try {signature.staff.records[i].staff_loyalty = $('#signature_' + i + '_Loyalty').val();} catch (err) { }
        try { $('#label_' + i + '_Loyalty').text(signature.staff.records[i].staff_loyalty); } catch (err) { }
        try {signature.staff.records[i].staff_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
        try {signature.staff.records[i].staff_email = $('#signature_' + i + '_Email').val();} catch (err) { }
        try { $('#label_' + i + '_Email').text(signature.staff.records[i].staff_email); } catch (err) { }
        try {signature.staff.records[i].staff_phone = $('#signature_' + i + '_Phone').val();} catch (err) { }
        try { $('#label_' + i + '_Phone').text(signature.staff.records[i].staff_phone); } catch (err) { }
        try {signature.staff.records[i].staff_street1 = $('#signature_' + i + '_Street1').val();} catch (err) { }
        try { $('#label_' + i + '_Street1').text(signature.staff.records[i].staff_street1); } catch (err) { }
        try {signature.staff.records[i].staff_street2 = $('#signature_' + i + '_Street2').val();} catch (err) { }
        try { $('#label_' + i + '_Street2').text(signature.staff.records[i].staff_street2); } catch (err) { }
        try {signature.staff.records[i].staff_city = $('#signature_' + i + '_City').val();} catch (err) { }
        try { $('#label_' + i + '_City').text(signature.staff.records[i].staff_city); } catch (err) { }
        try {signature.staff.records[i].staff_state = $('#signature_' + i + '_State').val();} catch (err) { }
        try { $('#label_' + i + '_State').text(signature.staff.records[i].staff_state); } catch (err) { }
        try {signature.staff.records[i].staff_zip = $('#signature_' + i + '_Zip').val();} catch (err) { }
        try { $('#label_' + i + '_Zip').text(signature.staff.records[i].staff_zip); } catch (err) { }
        try {signature.staff.records[i].label = signature.staff.records[i].staff_first+" "+signature.staff.records[i].staff_last; } catch (err) { }


        signature.staff.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.staff.records.length - 1; iy >= 0; iy--) {
            if (signature.staff.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.staff.isLoading && !signature.staff.list.includes(i)) {
            signature.staff.list.push(i);
            // console.log(i);
        }
        // signature.staff.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.staff.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.staff.displayweek();
        // signature.staff.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.staff.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.staff.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.staff.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.staff.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.staff.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.staff.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.staff.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.staff.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.staff.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.staff.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.staff.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.staffType.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.staff.records.length; i++) {
                    if (signature.staff.records[i][signature.staff.fieldprefix+'status'] === '1' && signature.staffType.records[ii].guid == signature.staff.records[i].staff_staff_type_mid) {
                        if (search.length > 0) {
                            if (signature.staff.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staffType.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.staff.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.staff.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staffType.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.staff.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.staff.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.staff.records[i]['label'], 'guid':signature.staff.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.staff.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.staff.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.staff.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.staff.doThisWhenDone("autosearch", 200, signature.staff.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'staff';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.staff.varUpdate();';
        } else {
            signature.v.save = 'signature.staff.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.staff.isLoading = true;
        


        if (signature.staff.isChild) {
            var data = {"field_id":"","label":"","guid":signature.staff.guid(),"staff_staff_type_mid":"","staff_first":"","staff_last":"","staff_status":"1","staff_loyalty":"","staff_permanent_makeup":"0","staff_email":"","staff_phone":"","staff_street1":"","staff_street2":"","staff_city":"","staff_state":"","staff_zip":"","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.staff.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.staff.records.length === 0) {
            signature.staff.add();
        } else {
            signature.staff.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.staff.update = JSON.stringify(signature.staff.records);
        // console.log('test');
        // signature.staff.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.staff.guid(),"staff_staff_type_mid":"","staff_first":"","staff_last":"","staff_status":"1","staff_loyalty":"","staff_permanent_makeup":"0","staff_email":"","staff_phone":"","staff_street1":"","staff_street2":"","staff_city":"","staff_state":"","staff_zip":"","action_del":"N"};

        signature.staff.varUpdate();
        signature.staff.records.push(data);
        signature.staff.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.staff.guid(),"staff_staff_type_mid":"","staff_first":"","staff_last":"","staff_status":"1","staff_loyalty":"","staff_permanent_makeup":"0","staff_email":"","staff_phone":"","staff_street1":"","staff_street2":"","staff_city":"","staff_state":"","staff_zip":"","action_del":"N"};

        signature.staff.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.hasFields()) {
                    try {if (signature.staff.records[i].staff_staff_type_mid !== $('#signature_' + i + '_Staff_Type_Mid').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {if (signature.staff.records[i].staff_label_first_last !== $('#signature_' + i + '_Label_First_Last').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_label_first_last = $('#signature_' + i + '_Label_First_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Label_First_Last').text(signature.staff.records[i].staff_label_first_last); } catch (err) { }
                    try {if (signature.staff.records[i].staff_first !== $('#signature_' + i + '_First').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_first = $('#signature_' + i + '_First').val();} catch (err) { }
                    try { $('#label_' + i + '_First').text(signature.staff.records[i].staff_first); } catch (err) { }
                    try {if (signature.staff.records[i].staff_last !== $('#signature_' + i + '_Last').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_last = $('#signature_' + i + '_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Last').text(signature.staff.records[i].staff_last); } catch (err) { }
                    try {if (signature.staff.records[i].staff_status !== $('#signature_' + i + '_Status').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {if (signature.staff.records[i].staff_loyalty !== $('#signature_' + i + '_Loyalty').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_loyalty = $('#signature_' + i + '_Loyalty').val();} catch (err) { }
                    try { $('#label_' + i + '_Loyalty').text(signature.staff.records[i].staff_loyalty); } catch (err) { }
                    try {if (signature.staff.records[i].staff_permanent_makeup !== $('#signature_' + i + '_Permanent_Makeup').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {if (signature.staff.records[i].staff_email !== $('#signature_' + i + '_Email').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_email = $('#signature_' + i + '_Email').val();} catch (err) { }
                    try { $('#label_' + i + '_Email').text(signature.staff.records[i].staff_email); } catch (err) { }
                    try {if (signature.staff.records[i].staff_phone !== $('#signature_' + i + '_Phone').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_phone = $('#signature_' + i + '_Phone').val();} catch (err) { }
                    try { $('#label_' + i + '_Phone').text(signature.staff.records[i].staff_phone); } catch (err) { }
                    try {if (signature.staff.records[i].staff_street1 !== $('#signature_' + i + '_Street1').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_street1 = $('#signature_' + i + '_Street1').val();} catch (err) { }
                    try { $('#label_' + i + '_Street1').text(signature.staff.records[i].staff_street1); } catch (err) { }
                    try {if (signature.staff.records[i].staff_street2 !== $('#signature_' + i + '_Street2').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_street2 = $('#signature_' + i + '_Street2').val();} catch (err) { }
                    try { $('#label_' + i + '_Street2').text(signature.staff.records[i].staff_street2); } catch (err) { }
                    try {if (signature.staff.records[i].staff_city !== $('#signature_' + i + '_City').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_city = $('#signature_' + i + '_City').val();} catch (err) { }
                    try { $('#label_' + i + '_City').text(signature.staff.records[i].staff_city); } catch (err) { }
                    try {if (signature.staff.records[i].staff_state !== $('#signature_' + i + '_State').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_state = $('#signature_' + i + '_State').val();} catch (err) { }
                    try { $('#label_' + i + '_State').text(signature.staff.records[i].staff_state); } catch (err) { }
                    try {if (signature.staff.records[i].staff_zip !== $('#signature_' + i + '_Zip').val()){signature.staff.listAdd(i);} } catch (err) { }
                    try {signature.staff.records[i].staff_zip = $('#signature_' + i + '_Zip').val();} catch (err) { }
                    try { $('#label_' + i + '_Zip').text(signature.staff.records[i].staff_zip); } catch (err) { }
                    try {signature.staff.records[i].label = signature.staff.records[i].staff_first+" "+signature.staff.records[i].staff_last; } catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.staff.records.length; i++){
//                 if (signature.staff.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.staff.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.staff.records.length - 1; iy >= 0; iy--) {
                if (signature.staff.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.staff.records.length; i++) {
                try {
                    if (signature.staff.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Staff_Type_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff Type') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Label_First_Last';
                        if ($(item).val().length && $(item).val() !== 'Label First Last') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_First';
                        if ($(item).val().length && $(item).val() !== 'First') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Last';
                        if ($(item).val().length && $(item).val() !== 'Last') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Loyalty';
                        if ($(item).val().length && $(item).val() !== 'Loyalty') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Permanent_Makeup';
                        if ($(item).val().length > 0  && $(item).val() !== 'Permanent Makeup') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Email';
                        if ($(item).val().length) {
                            if ($(item).val().includes("@") && $(item).val().includes(".")) {
                                $(item).parent().parent().css('border-color','');
                            } else {
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false;
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Phone';
                        if ($(item).val().length && $(item).val() !== 'Phone') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Street1';
                        if ($(item).val().length && $(item).val() !== 'Street1') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Street2';
                        if ($(item).val().length && $(item).val() !== 'Street2') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_City';
                        if ($(item).val().length && $(item).val() !== 'City') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_State';
                        if ($(item).val().length && $(item).val() !== 'State') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Zip';
                        if ($(item).val().length && $(item).val() !== 'Zip') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Availability_Json';
                        if ($(item).val().length && $(item).val() !== 'Availability Json') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.staff.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.staff.records);
        var two = signature.staff.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.staff.valid()) {
            signature.staff.varUpdate();
            if (eval(signature.staff.valid)) {
                if ( signature.staff.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.staff.records.length; i++) {
                        try {
                            try {signature.staff.records[i].staff_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {signature.staff.records[i].staff_label_first_last = $('#signature_' + i + '_Label_First_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Label_First_Last').text(signature.staff.records[i].staff_label_first_last); } catch (err) { }
                    try {signature.staff.records[i].staff_first = $('#signature_' + i + '_First').val();} catch (err) { }
                    try { $('#label_' + i + '_First').text(signature.staff.records[i].staff_first); } catch (err) { }
                    try {signature.staff.records[i].staff_last = $('#signature_' + i + '_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Last').text(signature.staff.records[i].staff_last); } catch (err) { }
                    try {signature.staff.records[i].staff_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.staff.records[i].staff_loyalty = $('#signature_' + i + '_Loyalty').val();} catch (err) { }
                    try { $('#label_' + i + '_Loyalty').text(signature.staff.records[i].staff_loyalty); } catch (err) { }
                    try {signature.staff.records[i].staff_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {signature.staff.records[i].staff_email = $('#signature_' + i + '_Email').val();} catch (err) { }
                    try { $('#label_' + i + '_Email').text(signature.staff.records[i].staff_email); } catch (err) { }
                    try {signature.staff.records[i].staff_phone = $('#signature_' + i + '_Phone').val();} catch (err) { }
                    try { $('#label_' + i + '_Phone').text(signature.staff.records[i].staff_phone); } catch (err) { }
                    try {signature.staff.records[i].staff_street1 = $('#signature_' + i + '_Street1').val();} catch (err) { }
                    try { $('#label_' + i + '_Street1').text(signature.staff.records[i].staff_street1); } catch (err) { }
                    try {signature.staff.records[i].staff_street2 = $('#signature_' + i + '_Street2').val();} catch (err) { }
                    try { $('#label_' + i + '_Street2').text(signature.staff.records[i].staff_street2); } catch (err) { }
                    try {signature.staff.records[i].staff_city = $('#signature_' + i + '_City').val();} catch (err) { }
                    try { $('#label_' + i + '_City').text(signature.staff.records[i].staff_city); } catch (err) { }
                    try {signature.staff.records[i].staff_state = $('#signature_' + i + '_State').val();} catch (err) { }
                    try { $('#label_' + i + '_State').text(signature.staff.records[i].staff_state); } catch (err) { }
                    try {signature.staff.records[i].staff_zip = $('#signature_' + i + '_Zip').val();} catch (err) { }
                    try { $('#label_' + i + '_Zip').text(signature.staff.records[i].staff_zip); } catch (err) { }
                    try {signature.staff.records[i].label = signature.staff.records[i].staff_first+" "+signature.staff.records[i].staff_last; } catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.staff.list.length; i++) {
                        sendThisData.push(signature.staff.records[signature.staff.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processStaff.php", $("#form").serialize())
                    $.post("processStaff.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.staff.send(); }
                            } else {
                                signature.staff.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.staff.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.staff.update = JSON.stringify(signature.staff.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.staff.shouldUpdate() ) {
            // signature.staff.thisweek();
        // }
        // signature.staff.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.staff.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.staff.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.staff.records.length; i++) {
            try {
                    try {signature.staff.records[i].staff_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {signature.staff.records[i].staff_label_first_last = $('#signature_' + i + '_Label_First_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Label_First_Last').text(signature.staff.records[i].staff_label_first_last); } catch (err) { }
                    try {signature.staff.records[i].staff_first = $('#signature_' + i + '_First').val();} catch (err) { }
                    try { $('#label_' + i + '_First').text(signature.staff.records[i].staff_first); } catch (err) { }
                    try {signature.staff.records[i].staff_last = $('#signature_' + i + '_Last').val();} catch (err) { }
                    try { $('#label_' + i + '_Last').text(signature.staff.records[i].staff_last); } catch (err) { }
                    try {signature.staff.records[i].staff_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.staff.records[i].staff_loyalty = $('#signature_' + i + '_Loyalty').val();} catch (err) { }
                    try { $('#label_' + i + '_Loyalty').text(signature.staff.records[i].staff_loyalty); } catch (err) { }
                    try {signature.staff.records[i].staff_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {signature.staff.records[i].staff_email = $('#signature_' + i + '_Email').val();} catch (err) { }
                    try { $('#label_' + i + '_Email').text(signature.staff.records[i].staff_email); } catch (err) { }
                    try {signature.staff.records[i].staff_phone = $('#signature_' + i + '_Phone').val();} catch (err) { }
                    try { $('#label_' + i + '_Phone').text(signature.staff.records[i].staff_phone); } catch (err) { }
                    try {signature.staff.records[i].staff_street1 = $('#signature_' + i + '_Street1').val();} catch (err) { }
                    try { $('#label_' + i + '_Street1').text(signature.staff.records[i].staff_street1); } catch (err) { }
                    try {signature.staff.records[i].staff_street2 = $('#signature_' + i + '_Street2').val();} catch (err) { }
                    try { $('#label_' + i + '_Street2').text(signature.staff.records[i].staff_street2); } catch (err) { }
                    try {signature.staff.records[i].staff_city = $('#signature_' + i + '_City').val();} catch (err) { }
                    try { $('#label_' + i + '_City').text(signature.staff.records[i].staff_city); } catch (err) { }
                    try {signature.staff.records[i].staff_state = $('#signature_' + i + '_State').val();} catch (err) { }
                    try { $('#label_' + i + '_State').text(signature.staff.records[i].staff_state); } catch (err) { }
                    try {signature.staff.records[i].staff_zip = $('#signature_' + i + '_Zip').val();} catch (err) { }
                    try { $('#label_' + i + '_Zip').text(signature.staff.records[i].staff_zip); } catch (err) { }
                    try {signature.staff.records[i].label = signature.staff.records[i].staff_first+" "+signature.staff.records[i].staff_last; } catch (err) { }


                signature.staff.records[i].action_del = 'N';
            } catch(err) {
                signature.staff.records[i].action_del = 'N';
            }
        }
        //signature.staff.records = JSON.parse(signature.v.recover);
        signature.staff.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.staff.records.length; i++) {
            if ( $( '#signature_' + i + '_First' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.staff.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.staff.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.staff.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Type_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff Type') }
            if ( $('#'+signature.v.lastID).hasClass('_First_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('First') }
            if ( $('#'+signature.v.lastID).hasClass('_Last_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Last') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }
            if ( $('#'+signature.v.lastID).hasClass('_Loyalty_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Loyalty') }
            if ( $('#'+signature.v.lastID).hasClass('_Permanent_Makeup_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Permanent Makeup') }
            if ( $('#'+signature.v.lastID).hasClass('_Email_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Email') }
            if ( $('#'+signature.v.lastID).hasClass('_Phone_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Phone') }
            if ( $('#'+signature.v.lastID).hasClass('_Street1_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Street1') }
            if ( $('#'+signature.v.lastID).hasClass('_Street2_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Street2') }
            if ( $('#'+signature.v.lastID).hasClass('_City_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('City') }
            if ( $('#'+signature.v.lastID).hasClass('_State_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('State') }
            if ( $('#'+signature.v.lastID).hasClass('_Zip_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Zip') }

            signature.staff.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.staff.varUpdate();
        for (var i = 0; i < signature.staff.records.length; i++) {
            try {
                if (signature.staff.records[i].action_del === 'N') {
                    try {signature.staff.records[i].staff_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.staff.records[i].staff_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}
                    try {signature.staff.records[i].staff_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    if (signature.staff.records[i].staff_permanent_makeup === '1') {$('#toggle_' + i + '_Permanent_Makeup_on').css('display','inline-block');$('#toggle_' + i + '_Permanent_Makeup_off').css('display','none');} else {$('#toggle_' + i + '_Permanent_Makeup_on').css('display','none');$('#toggle_' + i + '_Permanent_Makeup_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.staff.records[i]['guid'])
        $('#'+lid).text(signature.staff.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.staff.records.length; i++) {
                if (signature.staff.records[i][signature.staff.fieldprefix+'status'] === '1') {
                    labels.push(signature.staff.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.staff.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.staff.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.staff.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.staff.doThisWhenDone("autosearch", 200, signature.staff.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Staff_Type_Mid' === id && $('#'+id).val() === 'Staff Type') { $('#'+id).val('') }
        if ('signature_'+idx+'_First' === id && $('#'+id).val() === 'First') { $('#'+id).val('') }
        if ('signature_'+idx+'_Last' === id && $('#'+id).val() === 'Last') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }
        if ('signature_'+idx+'_Loyalty' === id && $('#'+id).val() === 'Loyalty') { $('#'+id).val('') }
        if ('signature_'+idx+'_Permanent_Makeup' === id && $('#'+id).val() === 'Permanent Makeup') { $('#'+id).val('') }
        if ('signature_'+idx+'_Email' === id && $('#'+id).val() === 'Email') { $('#'+id).val('') }
        if ('signature_'+idx+'_Phone' === id && $('#'+id).val() === 'Phone') { $('#'+id).val('') }
        if ('signature_'+idx+'_Street1' === id && $('#'+id).val() === 'Street1') { $('#'+id).val('') }
        if ('signature_'+idx+'_Street2' === id && $('#'+id).val() === 'Street2') { $('#'+id).val('') }
        if ('signature_'+idx+'_City' === id && $('#'+id).val() === 'City') { $('#'+id).val('') }
        if ('signature_'+idx+'_State' === id && $('#'+id).val() === 'State') { $('#'+id).val('') }
        if ('signature_'+idx+'_Zip' === id && $('#'+id).val() === 'Zip') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.staff.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, staff_type_mid, first, last, status, loyalty, permanent_makeup, email, phone, street1, street2, city, state, zip) {
            if (typeof i === 'undefined') {
                i = signature.staff.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof staff_type_mid === 'undefined') { staff_type_mid = ''; }
            if (typeof first === 'undefined') { first = ''; }
            if (typeof last === 'undefined') { last = ''; }
            if (typeof status === 'undefined') { status = '1'; }
            if (typeof loyalty === 'undefined') { loyalty = ''; }
            if (typeof permanent_makeup === 'undefined') { permanent_makeup = '0'; }
            if (typeof email === 'undefined') { email = ''; }
            if (typeof phone === 'undefined') { phone = ''; }
            if (typeof street1 === 'undefined') { street1 = ''; }
            if (typeof street2 === 'undefined') { street2 = ''; }
            if (typeof city === 'undefined') { city = ''; }
            if (typeof state === 'undefined') { state = ''; }
            if (typeof zip === 'undefined') { zip = ''; }


            if (staff_type_mid === '') { staff_type_mid = 'Staff Type'; }
            if (first === '') { first = 'First'; }
            if (last === '') { last = 'Last'; }
            if (status === '') { status = 'Status'; }
            if (loyalty === '') { loyalty = 'Loyalty'; }
            if (permanent_makeup === '') { permanent_makeup = 'Permanent Makeup'; }
            if (email === '') { email = 'Email'; }
            if (phone === '') { phone = 'Phone'; }
            if (street1 === '') { street1 = 'Street1'; }
            if (street2 === '') { street2 = 'Street2'; }
            if (city === '') { city = 'City'; }
            if (state === '') { state = 'State'; }
            if (zip === '') { zip = 'Zip'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.staff.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Type_Mid_" title="Staff Type">\
                    <div class="item_Label staff_type_mid" style="display:none;"> Staff Type: </div>\
                    <div id="eefStaff_Type_Mid" class="signatureField" onclick="signature.staff.select(\'Staff Type\',\'staffType\',\'staff_type_mid\',\'signature_' + i + '_Staff_Type_Mid\',\'label_' + i + '_Staff_Type_Mid_\',\'staff_type_label\');">\
                    	<span id="label_' + i + '_Staff_Type_Mid_">Staff Type</span>\
                        <input name="Staff_Type_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Type_Mid" class="resolvethisid signaturebox _Staff_Type_Mid_" value="' + staff_type_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="First">\
                    <div id="label_' + i + '_First" class="itemLabel first" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_First"> First: </div>\
                    <div id="eefFirst" class="signatureField">\
                        <input name="First_' + i + '" type="text" id="signature_' + i + '_First" class="signaturebox _First_" value="' + first + '" style="display:none;"  relatedfield="label_' + i + '_First" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Last">\
                    <div id="label_' + i + '_Last" class="itemLabel last" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Last"> Last: </div>\
                    <div id="eefLast" class="signatureField">\
                        <input name="Last_' + i + '" type="text" id="signature_' + i + '_Last" class="signaturebox _Last_" value="' + last + '" style="display:none;"  relatedfield="label_' + i + '_Last" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.staff.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
<div class="morebutton" onclick="$(\'#\'+$(this).parent().attr(\'id\')+\' .more\').css(\'display\',\'block\');$(\'#\'+$(this).parent().attr(\'id\')+\' .morebutton\').css(\'display\',\'none\');" style="display:inline-block; padding: 10px;"><sub>more</sub></div><div class="more" style="display:none;">\
                <div class="signatureItem" title="Loyalty">\
                    <div id="label_' + i + '_Loyalty" class="itemLabel loyalty" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Loyalty"> Loyalty: </div>\
                    <div id="eefLoyalty" class="signatureField">\
                        <input name="Loyalty_' + i + '" type="text" id="signature_' + i + '_Loyalty" class="signaturebox _Loyalty_" value="' + loyalty + '" style="display:none;"  relatedfield="label_' + i + '_Loyalty" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label permanent_makeup" style="display:none;"> Permanent Makeup: </div>\
                    <div id="eefPermanent_Makeup_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Permanent_Makeup_" onclick="signature.staff.toggle(\'eefPermanent_Makeup_' + i + '_\',\'permanent_makeup\',\'signature_' + i + '_Permanent_Makeup\',\'label_' + i + '_Permanent_Makeup_\');"><span id="label_' + i + '_Permanent_Makeup_" class="togglelabel" style="display:none;">Permanent Makeup</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Permanent_Makeup_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Permanent_Makeup_off" class="toggleOff">\
                        <input name="Permanent_Makeup_' + i + '" type="hidden" id="signature_' + i + '_Permanent_Makeup" class="signaturebox _Permanent_Makeup_" value="' + permanent_makeup + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Email">\
                    <div id="label_' + i + '_Email" class="itemLabel email" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Email"> Email: </div>\
                    <div id="eefEmail" class="signatureField">\
                        <input name="Email_' + i + '" type="text" id="signature_' + i + '_Email" class="signaturebox _Email_" value="' + email + '" style="display:none;"  relatedfield="label_' + i + '_Email" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Phone">\
                    <div id="label_' + i + '_Phone" class="itemLabel phone" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Phone"> Phone: </div>\
                    <div id="eefPhone" class="signatureField">\
                        <input name="Phone_' + i + '" type="text" id="signature_' + i + '_Phone" class="signaturebox _Phone_" value="' + phone + '" style="display:none;"  relatedfield="label_' + i + '_Phone" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Street1">\
                    <div id="label_' + i + '_Street1" class="itemLabel street1" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Street1"> Street1: </div>\
                    <div id="eefStreet1" class="signatureField">\
                        <input name="Street1_' + i + '" type="text" id="signature_' + i + '_Street1" class="signaturebox _Street1_" value="' + street1 + '" style="display:none;"  relatedfield="label_' + i + '_Street1" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Street2">\
                    <div id="label_' + i + '_Street2" class="itemLabel street2" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Street2"> Street2: </div>\
                    <div id="eefStreet2" class="signatureField">\
                        <input name="Street2_' + i + '" type="text" id="signature_' + i + '_Street2" class="signaturebox _Street2_" value="' + street2 + '" style="display:none;"  relatedfield="label_' + i + '_Street2" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="City">\
                    <div id="label_' + i + '_City" class="itemLabel city" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_City"> City: </div>\
                    <div id="eefCity" class="signatureField">\
                        <input name="City_' + i + '" type="text" id="signature_' + i + '_City" class="signaturebox _City_" value="' + city + '" style="display:none;"  relatedfield="label_' + i + '_City" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="State">\
                    <div id="label_' + i + '_State" class="itemLabel state" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_State"> State: </div>\
                    <div id="eefState" class="signatureField">\
                        <input name="State_' + i + '" type="text" id="signature_' + i + '_State" class="signaturebox _State_" value="' + state + '" style="display:none;"  relatedfield="label_' + i + '_State" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Zip">\
                    <div id="label_' + i + '_Zip" class="itemLabel zip" onclick="signature.staff.doThisWhenDone(\'field_focus\', 8000, signature.staff.formBlur);signature.staff.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Zip"> Zip: </div>\
                    <div id="eefZip" class="signatureField">\
                        <input name="Zip_' + i + '" type="text" id="signature_' + i + '_Zip" class="signaturebox _Zip_" value="' + zip + '" style="display:none;"  relatedfield="label_' + i + '_Zip" >\
                    </div>\
                </div>\
<div id="close" title="close more" onclick="$(this).parent().css(\'display\',\'none\');$(\'#\'+$(this).parent().parent().attr(\'id\')+\' .morebutton\').css(\'display\',\'inline-block\');" style="float:right;color: crimson;">X</div>\
</div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.staff.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.staff.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.staff.records.length; i++){

                if (signature.staff.records[i].action_del === 'N') {
                    if (signature.staff.isChild) {
                        if (signature.staff.parent === signature.staff.records[i][signature.staff.px]) {
                            signature.staff.htmlRow(i, signature.staff.records[i].field_id, signature.staff.records[i].guid, signature.staff.records[i].staff_staff_type_mid, signature.staff.records[i].staff_first, signature.staff.records[i].staff_last, signature.staff.records[i].staff_status, signature.staff.records[i].staff_loyalty, signature.staff.records[i].staff_permanent_makeup, signature.staff.records[i].staff_email, signature.staff.records[i].staff_phone, signature.staff.records[i].staff_street1, signature.staff.records[i].staff_street2, signature.staff.records[i].staff_city, signature.staff.records[i].staff_state, signature.staff.records[i].staff_zip);
                        }

                    } else {
                        signature.staff.htmlRow(i, signature.staff.records[i].field_id, signature.staff.records[i].guid, signature.staff.records[i].staff_staff_type_mid, signature.staff.records[i].staff_first, signature.staff.records[i].staff_last, signature.staff.records[i].staff_status, signature.staff.records[i].staff_loyalty, signature.staff.records[i].staff_permanent_makeup, signature.staff.records[i].staff_email, signature.staff.records[i].staff_phone, signature.staff.records[i].staff_street1, signature.staff.records[i].staff_street2, signature.staff.records[i].staff_city, signature.staff.records[i].staff_state, signature.staff.records[i].staff_zip);
                    }
                    
                    // signature.staff.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.staff.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.staff.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.staff.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.staff.doThisWhenDone('field_focus', 8000, signature.staff.formBlur);signature.staff.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.staff.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.staff.sectionlabel+'</div>');
        
        signature.staff.toggleSwitches();
        signature.staff.resolveids();
        signature.staff.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.staff.runDoThis(myLabel); }, waitforAbout);

        // signature.staff.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i].action_del === 'N') {
                    if (signature.staff.records[i][theKey1] === guid) {
                        signature.staff.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staff.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i].action_del === 'N') {
                    if (signature.staff.records[i][theKey1] === search1 && signature.staff.records[i][theKey2] === search2) {
                        signature.staff.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staff.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i].action_del === 'N') {
                    if (signature.staff.records[i][theKey1] === search1 && signature.staff.records[i][theKey2] === search2 && signature.staff.records[i][theKey3] === search3) {
                        signature.staff.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.staff.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i][theKey1] === search1 && signature.staff.records[i][theKey2] === search2) {
                    var result = signature.staff.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.staff.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i][theKey1] === guid) {
                    var result = signature.staff.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.staff.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.staff.records.length > 0) {

            var keys = Object.keys(signature.staff.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.staff.records.length; i++){
                if (signature.staff.records[i].guid === guid) {
                    var result = signature.staff.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.staff.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.services = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Services',
    fieldprefix: 'services_',
    del: function(i) {
        try {signature.services.records[i].services_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
        try {signature.services.records[i].services_category_mid = $('#signature_' + i + '_Category_Mid').val();} catch (err) { }
        try {signature.services.records[i].services_label = $('#signature_' + i + '_Label').val();} catch (err) { }
        try { $('#label_' + i + '_Label').text(signature.services.records[i].services_label); } catch (err) { }
        try {signature.services.records[i].services_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
        try { $('#label_' + i + '_Duration').text(signature.services.records[i].services_duration); } catch (err) { }
        try {signature.services.records[i].services_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
        try { $('#label_' + i + '_Dvalue').text(signature.services.records[i].services_dvalue); } catch (err) { }
        try {signature.services.records[i].services_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
        try {signature.services.records[i].services_status = $('#signature_' + i + '_Status').val();} catch (err) { }
        try {signature.services.records[i].services_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
        try {signature.services.records[i].label = signature.services.records[i].services_label; } catch (err) { }


        signature.services.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.services.records.length - 1; iy >= 0; iy--) {
            if (signature.services.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.services.isLoading && !signature.services.list.includes(i)) {
            signature.services.list.push(i);
            // console.log(i);
        }
        // signature.services.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.services.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.services.displayweek();
        // signature.services.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.services.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.services.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.services.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.services.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.services.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.services.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.services.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.services.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.services.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.services.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.services.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.category.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.services.records.length; i++) {
                    if (signature.services.records[i][signature.services.fieldprefix+'status'] === '1' && signature.category.records[ii].guid == signature.services.records[i].services_category_mid) {
                        if (search.length > 0) {
                            if (signature.services.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.category.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.services.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.services.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.category.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.services.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.services.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.services.records[i]['label'], 'guid':signature.services.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.services.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.services.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.services.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.services.doThisWhenDone("autosearch", 200, signature.services.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'services';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.services.varUpdate();';
        } else {
            signature.v.save = 'signature.services.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.services.isLoading = true;
        


        if (signature.services.isChild) {
            var data = {"field_id":"","label":"","guid":signature.services.guid(),"services_staff_type_mid":"","services_category_mid":"","services_label":"","services_duration":"","services_dvalue":"","services_addon":"0","services_status":"1","services_permanent_makeup":"0","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.services.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.services.records.length === 0) {
            signature.services.add();
        } else {
            signature.services.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.services.update = JSON.stringify(signature.services.records);
        // console.log('test');
        // signature.services.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.services.guid(),"services_staff_type_mid":"","services_category_mid":"","services_label":"","services_duration":"","services_dvalue":"","services_addon":"0","services_status":"1","services_permanent_makeup":"0","action_del":"N"};

        signature.services.varUpdate();
        signature.services.records.push(data);
        signature.services.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.services.guid(),"services_staff_type_mid":"","services_category_mid":"","services_label":"","services_duration":"","services_dvalue":"","services_addon":"0","services_status":"1","services_permanent_makeup":"0","action_del":"N"};

        signature.services.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.hasFields()) {
                    try {if (signature.services.records[i].services_staff_type_mid !== $('#signature_' + i + '_Staff_Type_Mid').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {if (signature.services.records[i].services_category_mid !== $('#signature_' + i + '_Category_Mid').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_category_mid = $('#signature_' + i + '_Category_Mid').val();} catch (err) { }
                    try {if (signature.services.records[i].services_label !== $('#signature_' + i + '_Label').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.services.records[i].services_label); } catch (err) { }
                    try {if (signature.services.records[i].services_duration !== $('#signature_' + i + '_Duration').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.services.records[i].services_duration); } catch (err) { }
                    try {if (signature.services.records[i].services_dvalue !== $('#signature_' + i + '_Dvalue').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.services.records[i].services_dvalue); } catch (err) { }
                    try {if (signature.services.records[i].services_addon !== $('#signature_' + i + '_Addon').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {if (signature.services.records[i].services_status !== $('#signature_' + i + '_Status').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {if (signature.services.records[i].services_permanent_makeup !== $('#signature_' + i + '_Permanent_Makeup').val()){signature.services.listAdd(i);} } catch (err) { }
                    try {signature.services.records[i].services_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {signature.services.records[i].label = signature.services.records[i].services_label; } catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.services.records.length; i++){
//                 if (signature.services.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.services.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.services.records.length - 1; iy >= 0; iy--) {
                if (signature.services.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.services.records.length; i++) {
                try {
                    if (signature.services.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Staff_Type_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff Type') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Category_Mid';
                        if ($(item).val().length && $(item).val() !== 'Category') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Label';
                        if ($(item).val().length && $(item).val() !== 'Label') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Duration';
                        if ($(item).val().length && $(item).val() !== 'Duration') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Dvalue';
                        if ($(item).val().length && $(item).val() !== 'Value') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Addon';
                        if ($(item).val().length > 0  && $(item).val() !== 'Addon') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Permanent_Makeup';
                        if ($(item).val().length > 0  && $(item).val() !== 'Permanent Makeup') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.services.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.services.records);
        var two = signature.services.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.services.valid()) {
            signature.services.varUpdate();
            if (eval(signature.services.valid)) {
                if ( signature.services.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.services.records.length; i++) {
                        try {
                            try {signature.services.records[i].services_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {signature.services.records[i].services_category_mid = $('#signature_' + i + '_Category_Mid').val();} catch (err) { }
                    try {signature.services.records[i].services_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.services.records[i].services_label); } catch (err) { }
                    try {signature.services.records[i].services_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.services.records[i].services_duration); } catch (err) { }
                    try {signature.services.records[i].services_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.services.records[i].services_dvalue); } catch (err) { }
                    try {signature.services.records[i].services_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {signature.services.records[i].services_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.services.records[i].services_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {signature.services.records[i].label = signature.services.records[i].services_label; } catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.services.list.length; i++) {
                        sendThisData.push(signature.services.records[signature.services.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processServices.php", $("#form").serialize())
                    $.post("processServices.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.services.send(); }
                            } else {
                                signature.services.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.services.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.services.update = JSON.stringify(signature.services.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.services.shouldUpdate() ) {
            // signature.services.thisweek();
        // }
        // signature.services.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.services.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.services.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.services.records.length; i++) {
            try {
                    try {signature.services.records[i].services_staff_type_mid = $('#signature_' + i + '_Staff_Type_Mid').val();} catch (err) { }
                    try {signature.services.records[i].services_category_mid = $('#signature_' + i + '_Category_Mid').val();} catch (err) { }
                    try {signature.services.records[i].services_label = $('#signature_' + i + '_Label').val();} catch (err) { }
                    try { $('#label_' + i + '_Label').text(signature.services.records[i].services_label); } catch (err) { }
                    try {signature.services.records[i].services_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.services.records[i].services_duration); } catch (err) { }
                    try {signature.services.records[i].services_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.services.records[i].services_dvalue); } catch (err) { }
                    try {signature.services.records[i].services_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {signature.services.records[i].services_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    try {signature.services.records[i].services_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    try {signature.services.records[i].label = signature.services.records[i].services_label; } catch (err) { }


                signature.services.records[i].action_del = 'N';
            } catch(err) {
                signature.services.records[i].action_del = 'N';
            }
        }
        //signature.services.records = JSON.parse(signature.v.recover);
        signature.services.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.services.records.length; i++) {
            if ( $( '#signature_' + i + '_Label' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.services.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.services.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.services.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Type_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff Type') }
            if ( $('#'+signature.v.lastID).hasClass('_Category_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Category') }
            if ( $('#'+signature.v.lastID).hasClass('_Label_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Label') }
            if ( $('#'+signature.v.lastID).hasClass('_Duration_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Duration') }
            if ( $('#'+signature.v.lastID).hasClass('_Dvalue_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Value') }
            if ( $('#'+signature.v.lastID).hasClass('_Addon_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Addon') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }
            if ( $('#'+signature.v.lastID).hasClass('_Permanent_Makeup_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Permanent Makeup') }

            signature.services.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.services.varUpdate();
        for (var i = 0; i < signature.services.records.length; i++) {
            try {
                if (signature.services.records[i].action_del === 'N') {
                    try {signature.services.records[i].services_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    if (signature.services.records[i].services_addon === '1') {$('#toggle_' + i + '_Addon_on').css('display','inline-block');$('#toggle_' + i + '_Addon_off').css('display','none');} else {$('#toggle_' + i + '_Addon_on').css('display','none');$('#toggle_' + i + '_Addon_off').css('display','inline-block');}
                    try {signature.services.records[i].services_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.services.records[i].services_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}
                    try {signature.services.records[i].services_permanent_makeup = $('#signature_' + i + '_Permanent_Makeup').val();} catch (err) { }
                    if (signature.services.records[i].services_permanent_makeup === '1') {$('#toggle_' + i + '_Permanent_Makeup_on').css('display','inline-block');$('#toggle_' + i + '_Permanent_Makeup_off').css('display','none');} else {$('#toggle_' + i + '_Permanent_Makeup_on').css('display','none');$('#toggle_' + i + '_Permanent_Makeup_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.services.records[i]['guid'])
        $('#'+lid).text(signature.services.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.services.records.length; i++) {
                if (signature.services.records[i][signature.services.fieldprefix+'status'] === '1') {
                    labels.push(signature.services.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.services.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.services.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.services.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.services.doThisWhenDone("autosearch", 200, signature.services.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Staff_Type_Mid' === id && $('#'+id).val() === 'Staff Type') { $('#'+id).val('') }
        if ('signature_'+idx+'_Category_Mid' === id && $('#'+id).val() === 'Category') { $('#'+id).val('') }
        if ('signature_'+idx+'_Label' === id && $('#'+id).val() === 'Label') { $('#'+id).val('') }
        if ('signature_'+idx+'_Duration' === id && $('#'+id).val() === 'Duration') { $('#'+id).val('') }
        if ('signature_'+idx+'_Dvalue' === id && $('#'+id).val() === 'Value') { $('#'+id).val('') }
        if ('signature_'+idx+'_Addon' === id && $('#'+id).val() === 'Addon') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }
        if ('signature_'+idx+'_Permanent_Makeup' === id && $('#'+id).val() === 'Permanent Makeup') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.services.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, staff_type_mid, category_mid, label, duration, dvalue, addon, status, permanent_makeup) {
            if (typeof i === 'undefined') {
                i = signature.services.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof staff_type_mid === 'undefined') { staff_type_mid = ''; }
            if (typeof category_mid === 'undefined') { category_mid = ''; }
            if (typeof label === 'undefined') { label = ''; }
            if (typeof duration === 'undefined') { duration = ''; }
            if (typeof dvalue === 'undefined') { dvalue = ''; }
            if (typeof addon === 'undefined') { addon = '0'; }
            if (typeof status === 'undefined') { status = '1'; }
            if (typeof permanent_makeup === 'undefined') { permanent_makeup = '0'; }


            if (staff_type_mid === '') { staff_type_mid = 'Staff Type'; }
            if (category_mid === '') { category_mid = 'Category'; }
            if (label === '') { label = 'Label'; }
            if (duration === '') { duration = 'Duration'; }
            if (dvalue === '') { dvalue = 'Value'; }
            if (addon === '') { addon = 'Addon'; }
            if (status === '') { status = 'Status'; }
            if (permanent_makeup === '') { permanent_makeup = 'Permanent Makeup'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.services.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Type_Mid_" title="Staff Type">\
                    <div class="item_Label staff_type_mid" style="display:none;"> Staff Type: </div>\
                    <div id="eefStaff_Type_Mid" class="signatureField" onclick="signature.services.select(\'Staff Type\',\'staffType\',\'staff_type_mid\',\'signature_' + i + '_Staff_Type_Mid\',\'label_' + i + '_Staff_Type_Mid_\',\'staff_type_label\');">\
                    	<span id="label_' + i + '_Staff_Type_Mid_">Staff Type</span>\
                        <input name="Staff_Type_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Type_Mid" class="resolvethisid signaturebox _Staff_Type_Mid_" value="' + staff_type_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Category_Mid_" title="Category">\
                    <div class="item_Label category_mid" style="display:none;"> Category: </div>\
                    <div id="eefCategory_Mid" class="signatureField" onclick="signature.services.select(\'Category\',\'category\',\'category_mid\',\'signature_' + i + '_Category_Mid\',\'label_' + i + '_Category_Mid_\',\'category_label\');">\
                    	<span id="label_' + i + '_Category_Mid_">Category</span>\
                        <input name="Category_Mid_' + i + '" type="hidden" id="signature_' + i + '_Category_Mid" class="resolvethisid signaturebox _Category_Mid_" value="' + category_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Label">\
                    <div id="label_' + i + '_Label" class="itemLabel label" onclick="signature.services.doThisWhenDone(\'field_focus\', 8000, signature.services.formBlur);signature.services.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Label"> Label: </div>\
                    <div id="eefLabel" class="signatureField">\
                        <input name="Label_' + i + '" type="text" id="signature_' + i + '_Label" class="signaturebox _Label_" value="' + label + '" style="display:none;"  relatedfield="label_' + i + '_Label" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Duration">\
                    <div id="label_' + i + '_Duration" class="itemLabel duration" onclick="signature.services.doThisWhenDone(\'field_focus\', 8000, signature.services.formBlur);signature.services.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Duration"> Duration: </div>\
                    <div id="eefDuration" class="signatureField">\
                        <input name="Duration_' + i + '" type="text" id="signature_' + i + '_Duration" class="signaturebox _Duration_" value="' + duration + '" style="display:none;"  relatedfield="label_' + i + '_Duration" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Value">\
                    <div id="label_' + i + '_Dvalue" class="itemLabel dvalue" onclick="signature.services.doThisWhenDone(\'field_focus\', 8000, signature.services.formBlur);signature.services.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Dvalue"> Value: </div>\
                    <div id="eefDvalue" class="signatureField">\
                        <input name="Dvalue_' + i + '" type="text" id="signature_' + i + '_Dvalue" class="signaturebox _Dvalue_" value="' + dvalue + '" style="display:none;"  relatedfield="label_' + i + '_Dvalue" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label addon" style="display:none;"> Addon: </div>\
                    <div id="eefAddon_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Addon_" onclick="signature.services.toggle(\'eefAddon_' + i + '_\',\'addon\',\'signature_' + i + '_Addon\',\'label_' + i + '_Addon_\');"><span id="label_' + i + '_Addon_" class="togglelabel" style="display:none;">Addon</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Addon_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Addon_off" class="toggleOff">\
                        <input name="Addon_' + i + '" type="hidden" id="signature_' + i + '_Addon" class="signaturebox _Addon_" value="' + addon + '">\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.services.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
<div class="morebutton" onclick="$(\'#\'+$(this).parent().attr(\'id\')+\' .more\').css(\'display\',\'block\');$(\'#\'+$(this).parent().attr(\'id\')+\' .morebutton\').css(\'display\',\'none\');" style="display:inline-block; padding: 10px;"><sub>more</sub></div><div class="more" style="display:none;">\
                <div class="signatureItem">\
                    <div class="item_Label permanent_makeup" style="display:none;"> Permanent Makeup: </div>\
                    <div id="eefPermanent_Makeup_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Permanent_Makeup_" onclick="signature.services.toggle(\'eefPermanent_Makeup_' + i + '_\',\'permanent_makeup\',\'signature_' + i + '_Permanent_Makeup\',\'label_' + i + '_Permanent_Makeup_\');"><span id="label_' + i + '_Permanent_Makeup_" class="togglelabel" style="display:none;">Permanent Makeup</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Permanent_Makeup_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Permanent_Makeup_off" class="toggleOff">\
                        <input name="Permanent_Makeup_' + i + '" type="hidden" id="signature_' + i + '_Permanent_Makeup" class="signaturebox _Permanent_Makeup_" value="' + permanent_makeup + '">\
                    </div>\
                </div>\
<div id="close" title="close more" onclick="$(this).parent().css(\'display\',\'none\');$(\'#\'+$(this).parent().parent().attr(\'id\')+\' .morebutton\').css(\'display\',\'inline-block\');" style="float:right;color: crimson;">X</div>\
</div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.services.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.services.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.services.records.length; i++){

                if (signature.services.records[i].action_del === 'N') {
                    if (signature.services.isChild) {
                        if (signature.services.parent === signature.services.records[i][signature.services.px]) {
                            signature.services.htmlRow(i, signature.services.records[i].field_id, signature.services.records[i].guid, signature.services.records[i].services_staff_type_mid, signature.services.records[i].services_category_mid, signature.services.records[i].services_label, signature.services.records[i].services_duration, signature.services.records[i].services_dvalue, signature.services.records[i].services_addon, signature.services.records[i].services_status, signature.services.records[i].services_permanent_makeup);
                        }

                    } else {
                        signature.services.htmlRow(i, signature.services.records[i].field_id, signature.services.records[i].guid, signature.services.records[i].services_staff_type_mid, signature.services.records[i].services_category_mid, signature.services.records[i].services_label, signature.services.records[i].services_duration, signature.services.records[i].services_dvalue, signature.services.records[i].services_addon, signature.services.records[i].services_status, signature.services.records[i].services_permanent_makeup);
                    }
                    
                    // signature.services.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.services.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.services.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.services.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.services.doThisWhenDone('field_focus', 8000, signature.services.formBlur);signature.services.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.services.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.services.sectionlabel+'</div>');
        
        signature.services.toggleSwitches();
        signature.services.resolveids();
        signature.services.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.services.runDoThis(myLabel); }, waitforAbout);

        // signature.services.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i].action_del === 'N') {
                    if (signature.services.records[i][theKey1] === guid) {
                        signature.services.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.services.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i].action_del === 'N') {
                    if (signature.services.records[i][theKey1] === search1 && signature.services.records[i][theKey2] === search2) {
                        signature.services.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.services.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i].action_del === 'N') {
                    if (signature.services.records[i][theKey1] === search1 && signature.services.records[i][theKey2] === search2 && signature.services.records[i][theKey3] === search3) {
                        signature.services.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.services.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i][theKey1] === search1 && signature.services.records[i][theKey2] === search2) {
                    var result = signature.services.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.services.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i][theKey1] === guid) {
                    var result = signature.services.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.services.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.services.records.length > 0) {

            var keys = Object.keys(signature.services.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.services.records.length; i++){
                if (signature.services.records[i].guid === guid) {
                    var result = signature.services.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.services.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.weeks = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Weeks',
    fieldprefix: 'weeks_',
    del: function(i) {
        try {signature.weeks.records[i].weeks_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
        try {signature.weeks.records[i].weeks_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
        try { $('#label_' + i + '_Epoch').text(signature.weeks.records[i].weeks_epoch); } catch (err) { }
        try {signature.weeks.records[i].weeks_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
        try { $('#label_' + i + '_Woy').text(signature.weeks.records[i].weeks_woy); } catch (err) { }
        try {signature.weeks.records[i].weeks_pmoney = $('#signature_' + i + '_Pmoney').val();} catch (err) { }
        try { $('#label_' + i + '_Pmoney').text(signature.weeks.records[i].weeks_pmoney); } catch (err) { }
        try {signature.weeks.records[i].weeks_cmoney = $('#signature_' + i + '_Cmoney').val();} catch (err) { }
        try { $('#label_' + i + '_Cmoney').text(signature.weeks.records[i].weeks_cmoney); } catch (err) { }
        try {signature.weeks.records[i].weeks_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
        try { $('#label_' + i + '_Duration').text(signature.weeks.records[i].weeks_duration); } catch (err) { }
        try {signature.weeks.records[i].weeks_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
        try { $('#label_' + i + '_Tip').text(signature.weeks.records[i].weeks_tip); } catch (err) { }
        try {signature.weeks.records[i].weeks_status = $('#signature_' + i + '_Status').val();} catch (err) { }


        signature.weeks.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.weeks.records.length - 1; iy >= 0; iy--) {
            if (signature.weeks.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.weeks.isLoading && !signature.weeks.list.includes(i)) {
            signature.weeks.list.push(i);
            // console.log(i);
        }
        // signature.weeks.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.weeks.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.weeks.displayweek();
        // signature.weeks.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.weeks.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.weeks.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.weeks.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.weeks.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.weeks.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.weeks.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.weeks.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.weeks.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.weeks.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.weeks.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.weeks.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.staff.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.weeks.records.length; i++) {
                    if (signature.weeks.records[i][signature.weeks.fieldprefix+'status'] === '1' && signature.staff.records[ii].guid == signature.weeks.records[i].weeks_staff_mid) {
                        if (search.length > 0) {
                            if (signature.weeks.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.weeks.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.weeks.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.weeks.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.weeks.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.weeks.records[i]['label'], 'guid':signature.weeks.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.weeks.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.weeks.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.weeks.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.weeks.doThisWhenDone("autosearch", 200, signature.weeks.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.weeks.varUpdate();';
        } else {
            signature.v.save = 'signature.weeks.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.weeks.isLoading = true;
        


        if (signature.weeks.isChild) {
            var data = {"field_id":"","label":"","guid":signature.weeks.guid(),"weeks_staff_mid":"","weeks_epoch":"","weeks_woy":"","weeks_pmoney":"","weeks_cmoney":"","weeks_duration":"","weeks_tip":"0","weeks_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.weeks.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.weeks.records.length === 0) {
            signature.weeks.add();
        } else {
            signature.weeks.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.weeks.update = JSON.stringify(signature.weeks.records);
        // console.log('test');
        // signature.weeks.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.weeks.guid(),"weeks_staff_mid":"","weeks_epoch":"","weeks_woy":"","weeks_pmoney":"","weeks_cmoney":"","weeks_duration":"","weeks_tip":"0","weeks_status":"1","action_del":"N"};

        signature.weeks.varUpdate();
        signature.weeks.records.push(data);
        signature.weeks.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.weeks.guid(),"weeks_staff_mid":"","weeks_epoch":"","weeks_woy":"","weeks_pmoney":"","weeks_cmoney":"","weeks_duration":"","weeks_tip":"0","weeks_status":"1","action_del":"N"};

        signature.weeks.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.hasFields()) {
                    try {if (signature.weeks.records[i].weeks_staff_mid !== $('#signature_' + i + '_Staff_Mid').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {if (signature.weeks.records[i].weeks_epoch !== $('#signature_' + i + '_Epoch').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weeks.records[i].weeks_epoch); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_woy !== $('#signature_' + i + '_Woy').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weeks.records[i].weeks_woy); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_pmoney !== $('#signature_' + i + '_Pmoney').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_pmoney = $('#signature_' + i + '_Pmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Pmoney').text(signature.weeks.records[i].weeks_pmoney); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_cmoney !== $('#signature_' + i + '_Cmoney').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_cmoney = $('#signature_' + i + '_Cmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Cmoney').text(signature.weeks.records[i].weeks_cmoney); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_duration !== $('#signature_' + i + '_Duration').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weeks.records[i].weeks_duration); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_tip !== $('#signature_' + i + '_Tip').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weeks.records[i].weeks_tip); } catch (err) { }
                    try {if (signature.weeks.records[i].weeks_status !== $('#signature_' + i + '_Status').val()){signature.weeks.listAdd(i);} } catch (err) { }
                    try {signature.weeks.records[i].weeks_status = $('#signature_' + i + '_Status').val();} catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.weeks.records.length; i++){
//                 if (signature.weeks.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.weeks.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.weeks.records.length - 1; iy >= 0; iy--) {
                if (signature.weeks.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.weeks.records.length; i++) {
                try {
                    if (signature.weeks.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Staff_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Epoch';
                        if ($(item).val().length && $(item).val() !== 'Epoch') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Woy';
                        if ($(item).val().length > 0  && $(item).val() !== 'Woy') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Pmoney';
                        if ($(item).val().length && $(item).val() !== 'Pmoney') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Cmoney';
                        if ($(item).val().length && $(item).val() !== 'Cmoney') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Duration';
                        if ($(item).val().length && $(item).val() !== 'Duration') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Tip';
                        if ($(item).val().length && $(item).val() !== 'Tip') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.weeks.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.weeks.records);
        var two = signature.weeks.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.weeks.valid()) {
            signature.weeks.varUpdate();
            if (eval(signature.weeks.valid)) {
                if ( signature.weeks.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.weeks.records.length; i++) {
                        try {
                            try {signature.weeks.records[i].weeks_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.weeks.records[i].weeks_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weeks.records[i].weeks_epoch); } catch (err) { }
                    try {signature.weeks.records[i].weeks_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weeks.records[i].weeks_woy); } catch (err) { }
                    try {signature.weeks.records[i].weeks_pmoney = $('#signature_' + i + '_Pmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Pmoney').text(signature.weeks.records[i].weeks_pmoney); } catch (err) { }
                    try {signature.weeks.records[i].weeks_cmoney = $('#signature_' + i + '_Cmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Cmoney').text(signature.weeks.records[i].weeks_cmoney); } catch (err) { }
                    try {signature.weeks.records[i].weeks_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weeks.records[i].weeks_duration); } catch (err) { }
                    try {signature.weeks.records[i].weeks_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weeks.records[i].weeks_tip); } catch (err) { }
                    try {signature.weeks.records[i].weeks_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.weeks.list.length; i++) {
                        sendThisData.push(signature.weeks.records[signature.weeks.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processWeeks.php", $("#form").serialize())
                    $.post("processWeeks.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.weeks.send(); }
                            } else {
                                signature.weeks.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.weeks.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.weeks.update = JSON.stringify(signature.weeks.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.weeks.shouldUpdate() ) {
            // signature.weeks.thisweek();
        // }
        // signature.weeks.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.weeks.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.weeks.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.weeks.records.length; i++) {
            try {
                    try {signature.weeks.records[i].weeks_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.weeks.records[i].weeks_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weeks.records[i].weeks_epoch); } catch (err) { }
                    try {signature.weeks.records[i].weeks_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weeks.records[i].weeks_woy); } catch (err) { }
                    try {signature.weeks.records[i].weeks_pmoney = $('#signature_' + i + '_Pmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Pmoney').text(signature.weeks.records[i].weeks_pmoney); } catch (err) { }
                    try {signature.weeks.records[i].weeks_cmoney = $('#signature_' + i + '_Cmoney').val();} catch (err) { }
                    try { $('#label_' + i + '_Cmoney').text(signature.weeks.records[i].weeks_cmoney); } catch (err) { }
                    try {signature.weeks.records[i].weeks_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weeks.records[i].weeks_duration); } catch (err) { }
                    try {signature.weeks.records[i].weeks_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weeks.records[i].weeks_tip); } catch (err) { }
                    try {signature.weeks.records[i].weeks_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                signature.weeks.records[i].action_del = 'N';
            } catch(err) {
                signature.weeks.records[i].action_del = 'N';
            }
        }
        //signature.weeks.records = JSON.parse(signature.v.recover);
        signature.weeks.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.weeks.records.length; i++) {
            if ( $( '#signature_' + i + '_Epoch' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.weeks.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.weeks.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.weeks.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff') }
            if ( $('#'+signature.v.lastID).hasClass('_Epoch_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Epoch') }
            if ( $('#'+signature.v.lastID).hasClass('_Woy_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Woy') }
            if ( $('#'+signature.v.lastID).hasClass('_Pmoney_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Pmoney') }
            if ( $('#'+signature.v.lastID).hasClass('_Cmoney_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Cmoney') }
            if ( $('#'+signature.v.lastID).hasClass('_Duration_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Duration') }
            if ( $('#'+signature.v.lastID).hasClass('_Tip_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Tip') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.weeks.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.weeks.varUpdate();
        for (var i = 0; i < signature.weeks.records.length; i++) {
            try {
                if (signature.weeks.records[i].action_del === 'N') {
                    try {signature.weeks.records[i].weeks_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.weeks.records[i].weeks_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.weeks.records[i]['guid'])
        $('#'+lid).text(signature.weeks.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.weeks.records.length; i++) {
                if (signature.weeks.records[i][signature.weeks.fieldprefix+'status'] === '1') {
                    labels.push(signature.weeks.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.weeks.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.weeks.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.weeks.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.weeks.doThisWhenDone("autosearch", 200, signature.weeks.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Staff_Mid' === id && $('#'+id).val() === 'Staff') { $('#'+id).val('') }
        if ('signature_'+idx+'_Epoch' === id && $('#'+id).val() === 'Epoch') { $('#'+id).val('') }
        if ('signature_'+idx+'_Woy' === id && $('#'+id).val() === 'Woy') { $('#'+id).val('') }
        if ('signature_'+idx+'_Pmoney' === id && $('#'+id).val() === 'Pmoney') { $('#'+id).val('') }
        if ('signature_'+idx+'_Cmoney' === id && $('#'+id).val() === 'Cmoney') { $('#'+id).val('') }
        if ('signature_'+idx+'_Duration' === id && $('#'+id).val() === 'Duration') { $('#'+id).val('') }
        if ('signature_'+idx+'_Tip' === id && $('#'+id).val() === 'Tip') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        signature.weekItems.parent = guid;  signature.weekItems.manage();


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.weeks.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, staff_mid, epoch, woy, pmoney, cmoney, duration, tip, status) {
            if (typeof i === 'undefined') {
                i = signature.weeks.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof staff_mid === 'undefined') { staff_mid = ''; }
            if (typeof epoch === 'undefined') { epoch = ''; }
            if (typeof woy === 'undefined') { woy = ''; }
            if (typeof pmoney === 'undefined') { pmoney = ''; }
            if (typeof cmoney === 'undefined') { cmoney = ''; }
            if (typeof duration === 'undefined') { duration = ''; }
            if (typeof tip === 'undefined') { tip = '0'; }
            if (typeof status === 'undefined') { status = '1'; }


            if (staff_mid === '') { staff_mid = 'Staff'; }
            if (epoch === '') { epoch = 'Epoch'; }
            if (woy === '') { woy = 'Woy'; }
            if (pmoney === '') { pmoney = 'Pmoney'; }
            if (cmoney === '') { cmoney = 'Cmoney'; }
            if (duration === '') { duration = 'Duration'; }
            if (tip === '') { tip = 'Tip'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.weeks.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Mid_" title="Staff">\
                    <div class="item_Label staff_mid" style="display:none;"> Staff: </div>\
                    <div id="eefStaff_Mid" class="signatureField" onclick="signature.weeks.select(\'Staff\',\'staff\',\'staff_mid\',\'signature_' + i + '_Staff_Mid\',\'label_' + i + '_Staff_Mid_\',\'staff_label_first_last\');">\
                    	<span id="label_' + i + '_Staff_Mid_">Staff</span>\
                        <input name="Staff_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Mid" class="resolvethisid signaturebox _Staff_Mid_" value="' + staff_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Epoch">\
                    <div id="label_' + i + '_Epoch" class="itemLabel epoch" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Epoch"> Epoch: </div>\
                    <div id="eefEpoch" class="signatureField">\
                        <input name="Epoch_' + i + '" type="text" id="signature_' + i + '_Epoch" class="signaturebox _Epoch_" value="' + epoch + '" style="display:none;"  relatedfield="label_' + i + '_Epoch" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Woy">\
                    <div id="label_' + i + '_Woy" class="itemLabel woy" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Woy"> Woy: </div>\
                    <div id="eefWoy" class="signatureField">\
                        <input name="Woy_' + i + '" type="text" id="signature_' + i + '_Woy" class="signaturebox _Woy_" value="' + woy + '" style="display:none;"  relatedfield="label_' + i + '_Woy" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Pmoney">\
                    <div id="label_' + i + '_Pmoney" class="itemLabel pmoney" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Pmoney"> Pmoney: </div>\
                    <div id="eefPmoney" class="signatureField">\
                        <input name="Pmoney_' + i + '" type="text" id="signature_' + i + '_Pmoney" class="signaturebox _Pmoney_" value="' + pmoney + '" style="display:none;"  relatedfield="label_' + i + '_Pmoney" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Cmoney">\
                    <div id="label_' + i + '_Cmoney" class="itemLabel cmoney" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Cmoney"> Cmoney: </div>\
                    <div id="eefCmoney" class="signatureField">\
                        <input name="Cmoney_' + i + '" type="text" id="signature_' + i + '_Cmoney" class="signaturebox _Cmoney_" value="' + cmoney + '" style="display:none;"  relatedfield="label_' + i + '_Cmoney" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Duration">\
                    <div id="label_' + i + '_Duration" class="itemLabel duration" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Duration"> Duration: </div>\
                    <div id="eefDuration" class="signatureField">\
                        <input name="Duration_' + i + '" type="text" id="signature_' + i + '_Duration" class="signaturebox _Duration_" value="' + duration + '" style="display:none;"  relatedfield="label_' + i + '_Duration" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Tip">\
                    <div id="label_' + i + '_Tip" class="itemLabel tip" onclick="signature.weeks.doThisWhenDone(\'field_focus\', 8000, signature.weeks.formBlur);signature.weeks.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Tip"> Tip: </div>\
                    <div id="eefTip" class="signatureField">\
                        <input name="Tip_' + i + '" type="text" id="signature_' + i + '_Tip" class="signaturebox _Tip_" value="' + tip + '" style="display:none;"  relatedfield="label_' + i + '_Tip" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.weeks.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                <div class="button managechildrenbutton" onclick="signature.weeks.managechildren(\'' + guid + '\')">Manage This</div><hr />\
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.weeks.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.weeks.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.weeks.records.length; i++){

                if (signature.weeks.records[i].action_del === 'N') {
                    if (signature.weeks.isChild) {
                        if (signature.weeks.parent === signature.weeks.records[i][signature.weeks.px]) {
                            signature.weeks.htmlRow(i, signature.weeks.records[i].field_id, signature.weeks.records[i].guid, signature.weeks.records[i].weeks_staff_mid, signature.weeks.records[i].weeks_epoch, signature.weeks.records[i].weeks_woy, signature.weeks.records[i].weeks_pmoney, signature.weeks.records[i].weeks_cmoney, signature.weeks.records[i].weeks_duration, signature.weeks.records[i].weeks_tip, signature.weeks.records[i].weeks_status);
                        }

                    } else {
                        signature.weeks.htmlRow(i, signature.weeks.records[i].field_id, signature.weeks.records[i].guid, signature.weeks.records[i].weeks_staff_mid, signature.weeks.records[i].weeks_epoch, signature.weeks.records[i].weeks_woy, signature.weeks.records[i].weeks_pmoney, signature.weeks.records[i].weeks_cmoney, signature.weeks.records[i].weeks_duration, signature.weeks.records[i].weeks_tip, signature.weeks.records[i].weeks_status);
                    }
                    
                    // signature.weeks.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.weeks.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.weeks.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.weeks.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.weeks.doThisWhenDone('field_focus', 8000, signature.weeks.formBlur);signature.weeks.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.weeks.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.weeks.sectionlabel+'</div>');
        
        signature.weeks.toggleSwitches();
        signature.weeks.resolveids();
        signature.weeks.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.weeks.runDoThis(myLabel); }, waitforAbout);

        // signature.weeks.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i].action_del === 'N') {
                    if (signature.weeks.records[i][theKey1] === guid) {
                        signature.weeks.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weeks.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i].action_del === 'N') {
                    if (signature.weeks.records[i][theKey1] === search1 && signature.weeks.records[i][theKey2] === search2) {
                        signature.weeks.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weeks.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i].action_del === 'N') {
                    if (signature.weeks.records[i][theKey1] === search1 && signature.weeks.records[i][theKey2] === search2 && signature.weeks.records[i][theKey3] === search3) {
                        signature.weeks.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weeks.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i][theKey1] === search1 && signature.weeks.records[i][theKey2] === search2) {
                    var result = signature.weeks.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.weeks.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i][theKey1] === guid) {
                    var result = signature.weeks.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.weeks.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.weeks.records.length > 0) {

            var keys = Object.keys(signature.weeks.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.weeks.records.length; i++){
                if (signature.weeks.records[i].guid === guid) {
                    var result = signature.weeks.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.weeks.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.weekItems = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: true,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Week Items',
    fieldprefix: 'week_items_',
    del: function(i) {
        try {signature.weekItems.records[i].week_items_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
        try {signature.weekItems.records[i].week_items_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
        try {signature.weekItems.records[i].week_items_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
        try { $('#label_' + i + '_Epoch').text(signature.weekItems.records[i].week_items_epoch); } catch (err) { }
        try {signature.weekItems.records[i].week_items_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
        try { $('#label_' + i + '_Woy').text(signature.weekItems.records[i].week_items_woy); } catch (err) { }
        try {signature.weekItems.records[i].week_items_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
        try { $('#label_' + i + '_Dvalue').text(signature.weekItems.records[i].week_items_dvalue); } catch (err) { }
        try {signature.weekItems.records[i].week_items_cnt = $('#signature_' + i + '_Cnt').val();} catch (err) { }
        try { $('#label_' + i + '_Cnt').text(signature.weekItems.records[i].week_items_cnt); } catch (err) { }
        try {signature.weekItems.records[i].week_items_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
        try { $('#label_' + i + '_Duration').text(signature.weekItems.records[i].week_items_duration); } catch (err) { }
        try {signature.weekItems.records[i].week_items_row = $('#signature_' + i + '_Row').val();} catch (err) { }
        try { $('#label_' + i + '_Row').text(signature.weekItems.records[i].week_items_row); } catch (err) { }
        try {signature.weekItems.records[i].week_items_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
        try { $('#label_' + i + '_Tip').text(signature.weekItems.records[i].week_items_tip); } catch (err) { }
        try {signature.weekItems.records[i].week_items_custom = $('#signature_' + i + '_Custom').val();} catch (err) { }
        try {signature.weekItems.records[i].week_items_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
        try {signature.weekItems.records[i].week_items_status = $('#signature_' + i + '_Status').val();} catch (err) { }


        signature.weekItems.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.weekItems.records.length - 1; iy >= 0; iy--) {
            if (signature.weekItems.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.weekItems.isLoading && !signature.weekItems.list.includes(i)) {
            signature.weekItems.list.push(i);
            // console.log(i);
        }
        // signature.weekItems.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.weekItems.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.weekItems.displayweek();
        // signature.weekItems.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.weekItems.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.weekItems.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.weekItems.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.weekItems.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.weekItems.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.weekItems.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.weekItems.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.weekItems.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.weekItems.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.weekItems.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.weekItems.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.staff.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.weekItems.records.length; i++) {
                    if (signature.weekItems.records[i][signature.weekItems.fieldprefix+'status'] === '1' && signature.staff.records[ii].guid == signature.weekItems.records[i].week_items_staff_mid) {
                        if (search.length > 0) {
                            if (signature.weekItems.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.weekItems.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.weekItems.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.weekItems.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.weekItems.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.weekItems.records[i]['label'], 'guid':signature.weekItems.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.weekItems.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.weekItems.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.weekItems.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.weekItems.doThisWhenDone("autosearch", 200, signature.weekItems.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'weekItems';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.weekItems.varUpdate();';
        } else {
            signature.v.save = 'signature.weekItems.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.weekItems.isLoading = true;
        


        if (signature.weekItems.isChild) {
            var data = {"field_id":"","label":"","guid":signature.weekItems.guid(),"week_items_services_mid":"","week_items_staff_mid":"","week_items_epoch":"","week_items_woy":"","week_items_dvalue":"","week_items_cnt":"","week_items_duration":"","week_items_row":"","week_items_tip":"0","week_items_custom":"0","week_items_addon":"0","week_items_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.weekItems.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.weekItems.records.length === 0) {
            signature.weekItems.add();
        } else {
            signature.weekItems.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.weekItems.update = JSON.stringify(signature.weekItems.records);
        // console.log('test');
        // signature.weekItems.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.weekItems.guid(),"week_items_services_mid":"","week_items_staff_mid":"","week_items_epoch":"","week_items_woy":"","week_items_dvalue":"","week_items_cnt":"","week_items_duration":"","week_items_row":"","week_items_tip":"0","week_items_custom":"0","week_items_addon":"0","week_items_status":"1","action_del":"N"};

        signature.weekItems.varUpdate();
        signature.weekItems.records.push(data);
        signature.weekItems.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.weekItems.guid(),"week_items_services_mid":"","week_items_staff_mid":"","week_items_epoch":"","week_items_woy":"","week_items_dvalue":"","week_items_cnt":"","week_items_duration":"","week_items_row":"","week_items_tip":"0","week_items_custom":"0","week_items_addon":"0","week_items_status":"1","action_del":"N"};

        signature.weekItems.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.hasFields()) {
                    try {if (signature.weekItems.records[i].week_items_services_mid !== $('#signature_' + i + '_Services_Mid').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_staff_mid !== $('#signature_' + i + '_Staff_Mid').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_epoch !== $('#signature_' + i + '_Epoch').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weekItems.records[i].week_items_epoch); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_woy !== $('#signature_' + i + '_Woy').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weekItems.records[i].week_items_woy); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_dvalue !== $('#signature_' + i + '_Dvalue').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.weekItems.records[i].week_items_dvalue); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_cnt !== $('#signature_' + i + '_Cnt').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_cnt = $('#signature_' + i + '_Cnt').val();} catch (err) { }
                    try { $('#label_' + i + '_Cnt').text(signature.weekItems.records[i].week_items_cnt); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_duration !== $('#signature_' + i + '_Duration').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weekItems.records[i].week_items_duration); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_row !== $('#signature_' + i + '_Row').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_row = $('#signature_' + i + '_Row').val();} catch (err) { }
                    try { $('#label_' + i + '_Row').text(signature.weekItems.records[i].week_items_row); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_tip !== $('#signature_' + i + '_Tip').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weekItems.records[i].week_items_tip); } catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_custom !== $('#signature_' + i + '_Custom').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_custom = $('#signature_' + i + '_Custom').val();} catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_addon !== $('#signature_' + i + '_Addon').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {if (signature.weekItems.records[i].week_items_status !== $('#signature_' + i + '_Status').val()){signature.weekItems.listAdd(i);} } catch (err) { }
                    try {signature.weekItems.records[i].week_items_status = $('#signature_' + i + '_Status').val();} catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.weekItems.records.length; i++){
//                 if (signature.weekItems.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.weekItems.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.weekItems.records.length - 1; iy >= 0; iy--) {
                if (signature.weekItems.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.weekItems.records.length; i++) {
                try {
                    if (signature.weekItems.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Services_Mid';
                        if ($(item).val().length && $(item).val() !== 'Services') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Staff_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Epoch';
                        if ($(item).val().length && $(item).val() !== 'Epoch') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Woy';
                        if ($(item).val().length > 0  && $(item).val() !== 'Woy') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Dvalue';
                        if ($(item).val().length && $(item).val() !== 'Value') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Cnt';
                        if ($(item).val().length > 0  && $(item).val() !== 'Cnt') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Duration';
                        if ($(item).val().length && $(item).val() !== 'Duration') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Row';
                        if ($(item).val().length > 0  && $(item).val() !== 'Row') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Tip';
                        if ($(item).val().length && $(item).val() !== 'Tip') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Custom';
                        if ($(item).val().length > 0  && $(item).val() !== 'Custom') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Addon';
                        if ($(item).val().length > 0  && $(item).val() !== 'Addon') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.weekItems.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.weekItems.records);
        var two = signature.weekItems.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.weekItems.valid()) {
            signature.weekItems.varUpdate();
            if (eval(signature.weekItems.valid)) {
                if ( signature.weekItems.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.weekItems.records.length; i++) {
                        try {
                            try {signature.weekItems.records[i].week_items_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weekItems.records[i].week_items_epoch); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weekItems.records[i].week_items_woy); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.weekItems.records[i].week_items_dvalue); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_cnt = $('#signature_' + i + '_Cnt').val();} catch (err) { }
                    try { $('#label_' + i + '_Cnt').text(signature.weekItems.records[i].week_items_cnt); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weekItems.records[i].week_items_duration); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_row = $('#signature_' + i + '_Row').val();} catch (err) { }
                    try { $('#label_' + i + '_Row').text(signature.weekItems.records[i].week_items_row); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weekItems.records[i].week_items_tip); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_custom = $('#signature_' + i + '_Custom').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.weekItems.list.length; i++) {
                        sendThisData.push(signature.weekItems.records[signature.weekItems.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processWeek_Items.php", $("#form").serialize())
                    $.post("processWeek_Items.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.weekItems.send(); }
                            } else {
                                signature.weekItems.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.weekItems.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.weekItems.update = JSON.stringify(signature.weekItems.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.weekItems.shouldUpdate() ) {
            // signature.weekItems.thisweek();
        // }
        // signature.weekItems.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.weekItems.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.weekItems.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.weekItems.records.length; i++) {
            try {
                    try {signature.weekItems.records[i].week_items_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.weekItems.records[i].week_items_epoch); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.weekItems.records[i].week_items_woy); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.weekItems.records[i].week_items_dvalue); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_cnt = $('#signature_' + i + '_Cnt').val();} catch (err) { }
                    try { $('#label_' + i + '_Cnt').text(signature.weekItems.records[i].week_items_cnt); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_duration = $('#signature_' + i + '_Duration').val();} catch (err) { }
                    try { $('#label_' + i + '_Duration').text(signature.weekItems.records[i].week_items_duration); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_row = $('#signature_' + i + '_Row').val();} catch (err) { }
                    try { $('#label_' + i + '_Row').text(signature.weekItems.records[i].week_items_row); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_tip = $('#signature_' + i + '_Tip').val();} catch (err) { }
                    try { $('#label_' + i + '_Tip').text(signature.weekItems.records[i].week_items_tip); } catch (err) { }
                    try {signature.weekItems.records[i].week_items_custom = $('#signature_' + i + '_Custom').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    try {signature.weekItems.records[i].week_items_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                signature.weekItems.records[i].action_del = 'N';
            } catch(err) {
                signature.weekItems.records[i].action_del = 'N';
            }
        }
        //signature.weekItems.records = JSON.parse(signature.v.recover);
        signature.weekItems.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.weekItems.records.length; i++) {
            if ( $( '#signature_' + i + '_Epoch' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.weekItems.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.weekItems.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.weekItems.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Services_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Services') }
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff') }
            if ( $('#'+signature.v.lastID).hasClass('_Epoch_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Epoch') }
            if ( $('#'+signature.v.lastID).hasClass('_Woy_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Woy') }
            if ( $('#'+signature.v.lastID).hasClass('_Dvalue_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Value') }
            if ( $('#'+signature.v.lastID).hasClass('_Cnt_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Cnt') }
            if ( $('#'+signature.v.lastID).hasClass('_Duration_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Duration') }
            if ( $('#'+signature.v.lastID).hasClass('_Row_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Row') }
            if ( $('#'+signature.v.lastID).hasClass('_Tip_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Tip') }
            if ( $('#'+signature.v.lastID).hasClass('_Custom_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Custom') }
            if ( $('#'+signature.v.lastID).hasClass('_Addon_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Addon') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.weekItems.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.weekItems.varUpdate();
        for (var i = 0; i < signature.weekItems.records.length; i++) {
            try {
                if (signature.weekItems.records[i].action_del === 'N') {
                    try {signature.weekItems.records[i].week_items_custom = $('#signature_' + i + '_Custom').val();} catch (err) { }
                    if (signature.weekItems.records[i].week_items_custom === '1') {$('#toggle_' + i + '_Custom_on').css('display','inline-block');$('#toggle_' + i + '_Custom_off').css('display','none');} else {$('#toggle_' + i + '_Custom_on').css('display','none');$('#toggle_' + i + '_Custom_off').css('display','inline-block');}
                    try {signature.weekItems.records[i].week_items_addon = $('#signature_' + i + '_Addon').val();} catch (err) { }
                    if (signature.weekItems.records[i].week_items_addon === '1') {$('#toggle_' + i + '_Addon_on').css('display','inline-block');$('#toggle_' + i + '_Addon_off').css('display','none');} else {$('#toggle_' + i + '_Addon_on').css('display','none');$('#toggle_' + i + '_Addon_off').css('display','inline-block');}
                    try {signature.weekItems.records[i].week_items_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.weekItems.records[i].week_items_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.weekItems.records[i]['guid'])
        $('#'+lid).text(signature.weekItems.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.weekItems.records.length; i++) {
                if (signature.weekItems.records[i][signature.weekItems.fieldprefix+'status'] === '1') {
                    labels.push(signature.weekItems.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.weekItems.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.weekItems.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.weekItems.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.weekItems.doThisWhenDone("autosearch", 200, signature.weekItems.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Services_Mid' === id && $('#'+id).val() === 'Services') { $('#'+id).val('') }
        if ('signature_'+idx+'_Staff_Mid' === id && $('#'+id).val() === 'Staff') { $('#'+id).val('') }
        if ('signature_'+idx+'_Epoch' === id && $('#'+id).val() === 'Epoch') { $('#'+id).val('') }
        if ('signature_'+idx+'_Woy' === id && $('#'+id).val() === 'Woy') { $('#'+id).val('') }
        if ('signature_'+idx+'_Dvalue' === id && $('#'+id).val() === 'Value') { $('#'+id).val('') }
        if ('signature_'+idx+'_Cnt' === id && $('#'+id).val() === 'Cnt') { $('#'+id).val('') }
        if ('signature_'+idx+'_Duration' === id && $('#'+id).val() === 'Duration') { $('#'+id).val('') }
        if ('signature_'+idx+'_Row' === id && $('#'+id).val() === 'Row') { $('#'+id).val('') }
        if ('signature_'+idx+'_Tip' === id && $('#'+id).val() === 'Tip') { $('#'+id).val('') }
        if ('signature_'+idx+'_Custom' === id && $('#'+id).val() === 'Custom') { $('#'+id).val('') }
        if ('signature_'+idx+'_Addon' === id && $('#'+id).val() === 'Addon') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.weekItems.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, services_mid, staff_mid, epoch, woy, dvalue, cnt, duration, row, tip, custom, addon, status) {
            if (typeof i === 'undefined') {
                i = signature.weekItems.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof services_mid === 'undefined') { services_mid = ''; }
            if (typeof staff_mid === 'undefined') { staff_mid = ''; }
            if (typeof epoch === 'undefined') { epoch = ''; }
            if (typeof woy === 'undefined') { woy = ''; }
            if (typeof dvalue === 'undefined') { dvalue = ''; }
            if (typeof cnt === 'undefined') { cnt = ''; }
            if (typeof duration === 'undefined') { duration = ''; }
            if (typeof row === 'undefined') { row = ''; }
            if (typeof tip === 'undefined') { tip = '0'; }
            if (typeof custom === 'undefined') { custom = '0'; }
            if (typeof addon === 'undefined') { addon = '0'; }
            if (typeof status === 'undefined') { status = '1'; }


            if (services_mid === '') { services_mid = 'Services'; }
            if (staff_mid === '') { staff_mid = 'Staff'; }
            if (epoch === '') { epoch = 'Epoch'; }
            if (woy === '') { woy = 'Woy'; }
            if (dvalue === '') { dvalue = 'Value'; }
            if (cnt === '') { cnt = 'Cnt'; }
            if (duration === '') { duration = 'Duration'; }
            if (row === '') { row = 'Row'; }
            if (tip === '') { tip = 'Tip'; }
            if (custom === '') { custom = 'Custom'; }
            if (addon === '') { addon = 'Addon'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.weekItems.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Services_Mid_" title="Services">\
                    <div class="item_Label services_mid" style="display:none;"> Services: </div>\
                    <div id="eefServices_Mid" class="signatureField" onclick="signature.weekItems.select(\'Services\',\'services\',\'services_mid\',\'signature_' + i + '_Services_Mid\',\'label_' + i + '_Services_Mid_\',\'services_label\');">\
                    	<span id="label_' + i + '_Services_Mid_">Services</span>\
                        <input name="Services_Mid_' + i + '" type="hidden" id="signature_' + i + '_Services_Mid" class="resolvethisid signaturebox _Services_Mid_" value="' + services_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Mid_" title="Staff">\
                    <div class="item_Label staff_mid" style="display:none;"> Staff: </div>\
                    <div id="eefStaff_Mid" class="signatureField" onclick="signature.weekItems.select(\'Staff\',\'staff\',\'staff_mid\',\'signature_' + i + '_Staff_Mid\',\'label_' + i + '_Staff_Mid_\',\'staff_label_first_last\');">\
                    	<span id="label_' + i + '_Staff_Mid_">Staff</span>\
                        <input name="Staff_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Mid" class="resolvethisid signaturebox _Staff_Mid_" value="' + staff_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Epoch">\
                    <div id="label_' + i + '_Epoch" class="itemLabel epoch" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Epoch"> Epoch: </div>\
                    <div id="eefEpoch" class="signatureField">\
                        <input name="Epoch_' + i + '" type="text" id="signature_' + i + '_Epoch" class="signaturebox _Epoch_" value="' + epoch + '" style="display:none;"  relatedfield="label_' + i + '_Epoch" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Woy">\
                    <div id="label_' + i + '_Woy" class="itemLabel woy" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Woy"> Woy: </div>\
                    <div id="eefWoy" class="signatureField">\
                        <input name="Woy_' + i + '" type="text" id="signature_' + i + '_Woy" class="signaturebox _Woy_" value="' + woy + '" style="display:none;"  relatedfield="label_' + i + '_Woy" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Value">\
                    <div id="label_' + i + '_Dvalue" class="itemLabel dvalue" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Dvalue"> Value: </div>\
                    <div id="eefDvalue" class="signatureField">\
                        <input name="Dvalue_' + i + '" type="text" id="signature_' + i + '_Dvalue" class="signaturebox _Dvalue_" value="' + dvalue + '" style="display:none;"  relatedfield="label_' + i + '_Dvalue" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Cnt">\
                    <div id="label_' + i + '_Cnt" class="itemLabel cnt" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Cnt"> Cnt: </div>\
                    <div id="eefCnt" class="signatureField">\
                        <input name="Cnt_' + i + '" type="text" id="signature_' + i + '_Cnt" class="signaturebox _Cnt_" value="' + cnt + '" style="display:none;"  relatedfield="label_' + i + '_Cnt" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Duration">\
                    <div id="label_' + i + '_Duration" class="itemLabel duration" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Duration"> Duration: </div>\
                    <div id="eefDuration" class="signatureField">\
                        <input name="Duration_' + i + '" type="text" id="signature_' + i + '_Duration" class="signaturebox _Duration_" value="' + duration + '" style="display:none;"  relatedfield="label_' + i + '_Duration" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Row">\
                    <div id="label_' + i + '_Row" class="itemLabel row" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Row"> Row: </div>\
                    <div id="eefRow" class="signatureField">\
                        <input name="Row_' + i + '" type="text" id="signature_' + i + '_Row" class="signaturebox _Row_" value="' + row + '" style="display:none;"  relatedfield="label_' + i + '_Row" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Tip">\
                    <div id="label_' + i + '_Tip" class="itemLabel tip" onclick="signature.weekItems.doThisWhenDone(\'field_focus\', 8000, signature.weekItems.formBlur);signature.weekItems.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Tip"> Tip: </div>\
                    <div id="eefTip" class="signatureField">\
                        <input name="Tip_' + i + '" type="text" id="signature_' + i + '_Tip" class="signaturebox _Tip_" value="' + tip + '" style="display:none;"  relatedfield="label_' + i + '_Tip" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label custom" style="display:none;"> Custom: </div>\
                    <div id="eefCustom_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Custom_" onclick="signature.weekItems.toggle(\'eefCustom_' + i + '_\',\'custom\',\'signature_' + i + '_Custom\',\'label_' + i + '_Custom_\');"><span id="label_' + i + '_Custom_" class="togglelabel" style="display:none;">Custom</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Custom_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Custom_off" class="toggleOff">\
                        <input name="Custom_' + i + '" type="hidden" id="signature_' + i + '_Custom" class="signaturebox _Custom_" value="' + custom + '">\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label addon" style="display:none;"> Addon: </div>\
                    <div id="eefAddon_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Addon_" onclick="signature.weekItems.toggle(\'eefAddon_' + i + '_\',\'addon\',\'signature_' + i + '_Addon\',\'label_' + i + '_Addon_\');"><span id="label_' + i + '_Addon_" class="togglelabel" style="display:none;">Addon</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Addon_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Addon_off" class="toggleOff">\
                        <input name="Addon_' + i + '" type="hidden" id="signature_' + i + '_Addon" class="signaturebox _Addon_" value="' + addon + '">\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.weekItems.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.weekItems.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.weekItems.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.weekItems.records.length; i++){

                if (signature.weekItems.records[i].action_del === 'N') {
                    if (signature.weekItems.isChild) {
                        if (signature.weekItems.parent === signature.weekItems.records[i][signature.weekItems.px]) {
                            signature.weekItems.htmlRow(i, signature.weekItems.records[i].field_id, signature.weekItems.records[i].guid, signature.weekItems.records[i].week_items_services_mid, signature.weekItems.records[i].week_items_staff_mid, signature.weekItems.records[i].week_items_epoch, signature.weekItems.records[i].week_items_woy, signature.weekItems.records[i].week_items_dvalue, signature.weekItems.records[i].week_items_cnt, signature.weekItems.records[i].week_items_duration, signature.weekItems.records[i].week_items_row, signature.weekItems.records[i].week_items_tip, signature.weekItems.records[i].week_items_custom, signature.weekItems.records[i].week_items_addon, signature.weekItems.records[i].week_items_status);
                        }

                    } else {
                        signature.weekItems.htmlRow(i, signature.weekItems.records[i].field_id, signature.weekItems.records[i].guid, signature.weekItems.records[i].week_items_services_mid, signature.weekItems.records[i].week_items_staff_mid, signature.weekItems.records[i].week_items_epoch, signature.weekItems.records[i].week_items_woy, signature.weekItems.records[i].week_items_dvalue, signature.weekItems.records[i].week_items_cnt, signature.weekItems.records[i].week_items_duration, signature.weekItems.records[i].week_items_row, signature.weekItems.records[i].week_items_tip, signature.weekItems.records[i].week_items_custom, signature.weekItems.records[i].week_items_addon, signature.weekItems.records[i].week_items_status);
                    }
                    
                    // signature.weekItems.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.weekItems.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.weekItems.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.weekItems.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.weekItems.doThisWhenDone('field_focus', 8000, signature.weekItems.formBlur);signature.weekItems.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.weekItems.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.weekItems.sectionlabel+'</div>');
        
        signature.weekItems.toggleSwitches();
        signature.weekItems.resolveids();
        signature.weekItems.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.weekItems.runDoThis(myLabel); }, waitforAbout);

        // signature.weekItems.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i].action_del === 'N') {
                    if (signature.weekItems.records[i][theKey1] === guid) {
                        signature.weekItems.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weekItems.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i].action_del === 'N') {
                    if (signature.weekItems.records[i][theKey1] === search1 && signature.weekItems.records[i][theKey2] === search2) {
                        signature.weekItems.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weekItems.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i].action_del === 'N') {
                    if (signature.weekItems.records[i][theKey1] === search1 && signature.weekItems.records[i][theKey2] === search2 && signature.weekItems.records[i][theKey3] === search3) {
                        signature.weekItems.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.weekItems.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i][theKey1] === search1 && signature.weekItems.records[i][theKey2] === search2) {
                    var result = signature.weekItems.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.weekItems.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i][theKey1] === guid) {
                    var result = signature.weekItems.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.weekItems.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.weekItems.records.length > 0) {

            var keys = Object.keys(signature.weekItems.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.weekItems.records.length; i++){
                if (signature.weekItems.records[i].guid === guid) {
                    var result = signature.weekItems.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.weekItems.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.payscale = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Payscale',
    fieldprefix: 'payscale_',
    del: function(i) {
        try {signature.payscale.records[i].payscale_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
        try {signature.payscale.records[i].payscale_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
        try {signature.payscale.records[i].payscale_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
        try { $('#label_' + i + '_Dvalue').text(signature.payscale.records[i].payscale_dvalue); } catch (err) { }
        try {signature.payscale.records[i].payscale_status = $('#signature_' + i + '_Status').val();} catch (err) { }


        signature.payscale.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.payscale.records.length - 1; iy >= 0; iy--) {
            if (signature.payscale.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.payscale.isLoading && !signature.payscale.list.includes(i)) {
            signature.payscale.list.push(i);
            // console.log(i);
        }
        // signature.payscale.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.payscale.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.payscale.displayweek();
        // signature.payscale.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.payscale.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.payscale.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.payscale.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.payscale.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.payscale.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.payscale.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.payscale.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.payscale.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.payscale.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.payscale.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.payscale.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.staff.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.payscale.records.length; i++) {
                    if (signature.payscale.records[i][signature.payscale.fieldprefix+'status'] === '1' && signature.staff.records[ii].guid == signature.payscale.records[i].payscale_staff_mid) {
                        if (search.length > 0) {
                            if (signature.payscale.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.payscale.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.payscale.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.payscale.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.payscale.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.payscale.records[i]['label'], 'guid':signature.payscale.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.payscale.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.payscale.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.payscale.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.payscale.doThisWhenDone("autosearch", 200, signature.payscale.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'payscale';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.payscale.varUpdate();';
        } else {
            signature.v.save = 'signature.payscale.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.payscale.isLoading = true;
        


        if (signature.payscale.isChild) {
            var data = {"field_id":"","label":"","guid":signature.payscale.guid(),"payscale_services_mid":"","payscale_staff_mid":"","payscale_dvalue":"","payscale_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.payscale.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.payscale.records.length === 0) {
            signature.payscale.add();
        } else {
            signature.payscale.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.payscale.update = JSON.stringify(signature.payscale.records);
        // console.log('test');
        // signature.payscale.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.payscale.guid(),"payscale_services_mid":"","payscale_staff_mid":"","payscale_dvalue":"","payscale_status":"1","action_del":"N"};

        signature.payscale.varUpdate();
        signature.payscale.records.push(data);
        signature.payscale.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.payscale.guid(),"payscale_services_mid":"","payscale_staff_mid":"","payscale_dvalue":"","payscale_status":"1","action_del":"N"};

        signature.payscale.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.hasFields()) {
                    try {if (signature.payscale.records[i].payscale_services_mid !== $('#signature_' + i + '_Services_Mid').val()){signature.payscale.listAdd(i);} } catch (err) { }
                    try {signature.payscale.records[i].payscale_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {if (signature.payscale.records[i].payscale_staff_mid !== $('#signature_' + i + '_Staff_Mid').val()){signature.payscale.listAdd(i);} } catch (err) { }
                    try {signature.payscale.records[i].payscale_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {if (signature.payscale.records[i].payscale_dvalue !== $('#signature_' + i + '_Dvalue').val()){signature.payscale.listAdd(i);} } catch (err) { }
                    try {signature.payscale.records[i].payscale_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.payscale.records[i].payscale_dvalue); } catch (err) { }
                    try {if (signature.payscale.records[i].payscale_status !== $('#signature_' + i + '_Status').val()){signature.payscale.listAdd(i);} } catch (err) { }
                    try {signature.payscale.records[i].payscale_status = $('#signature_' + i + '_Status').val();} catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.payscale.records.length; i++){
//                 if (signature.payscale.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.payscale.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.payscale.records.length - 1; iy >= 0; iy--) {
                if (signature.payscale.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.payscale.records.length; i++) {
                try {
                    if (signature.payscale.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Services_Mid';
                        if ($(item).val().length && $(item).val() !== 'Services') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Staff_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Dvalue';
                        if ($(item).val().length && $(item).val() !== 'Value') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.payscale.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.payscale.records);
        var two = signature.payscale.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.payscale.valid()) {
            signature.payscale.varUpdate();
            if (eval(signature.payscale.valid)) {
                if ( signature.payscale.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.payscale.records.length; i++) {
                        try {
                            try {signature.payscale.records[i].payscale_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {signature.payscale.records[i].payscale_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.payscale.records[i].payscale_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.payscale.records[i].payscale_dvalue); } catch (err) { }
                    try {signature.payscale.records[i].payscale_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.payscale.list.length; i++) {
                        sendThisData.push(signature.payscale.records[signature.payscale.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processPayscale.php", $("#form").serialize())
                    $.post("processPayscale.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.payscale.send(); }
                            } else {
                                signature.payscale.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.payscale.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.payscale.update = JSON.stringify(signature.payscale.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.payscale.shouldUpdate() ) {
            // signature.payscale.thisweek();
        // }
        // signature.payscale.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.payscale.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.payscale.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.payscale.records.length; i++) {
            try {
                    try {signature.payscale.records[i].payscale_services_mid = $('#signature_' + i + '_Services_Mid').val();} catch (err) { }
                    try {signature.payscale.records[i].payscale_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.payscale.records[i].payscale_dvalue = $('#signature_' + i + '_Dvalue').val();} catch (err) { }
                    try { $('#label_' + i + '_Dvalue').text(signature.payscale.records[i].payscale_dvalue); } catch (err) { }
                    try {signature.payscale.records[i].payscale_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                signature.payscale.records[i].action_del = 'N';
            } catch(err) {
                signature.payscale.records[i].action_del = 'N';
            }
        }
        //signature.payscale.records = JSON.parse(signature.v.recover);
        signature.payscale.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.payscale.records.length; i++) {
            if ( $( '#signature_' + i + '_Dvalue' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.payscale.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.payscale.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.payscale.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Services_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Services') }
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff') }
            if ( $('#'+signature.v.lastID).hasClass('_Dvalue_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Value') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.payscale.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.payscale.varUpdate();
        for (var i = 0; i < signature.payscale.records.length; i++) {
            try {
                if (signature.payscale.records[i].action_del === 'N') {
                    try {signature.payscale.records[i].payscale_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.payscale.records[i].payscale_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.payscale.records[i]['guid'])
        $('#'+lid).text(signature.payscale.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.payscale.records.length; i++) {
                if (signature.payscale.records[i][signature.payscale.fieldprefix+'status'] === '1') {
                    labels.push(signature.payscale.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.payscale.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.payscale.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.payscale.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.payscale.doThisWhenDone("autosearch", 200, signature.payscale.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Services_Mid' === id && $('#'+id).val() === 'Services') { $('#'+id).val('') }
        if ('signature_'+idx+'_Staff_Mid' === id && $('#'+id).val() === 'Staff') { $('#'+id).val('') }
        if ('signature_'+idx+'_Dvalue' === id && $('#'+id).val() === 'Value') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.payscale.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, services_mid, staff_mid, dvalue, status) {
            if (typeof i === 'undefined') {
                i = signature.payscale.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof services_mid === 'undefined') { services_mid = ''; }
            if (typeof staff_mid === 'undefined') { staff_mid = ''; }
            if (typeof dvalue === 'undefined') { dvalue = ''; }
            if (typeof status === 'undefined') { status = '1'; }


            if (services_mid === '') { services_mid = 'Services'; }
            if (staff_mid === '') { staff_mid = 'Staff'; }
            if (dvalue === '') { dvalue = 'Value'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.payscale.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Services_Mid_" title="Services">\
                    <div class="item_Label services_mid" style="display:none;"> Services: </div>\
                    <div id="eefServices_Mid" class="signatureField" onclick="signature.payscale.select(\'Services\',\'services\',\'services_mid\',\'signature_' + i + '_Services_Mid\',\'label_' + i + '_Services_Mid_\',\'services_label\');">\
                    	<span id="label_' + i + '_Services_Mid_">Services</span>\
                        <input name="Services_Mid_' + i + '" type="hidden" id="signature_' + i + '_Services_Mid" class="resolvethisid signaturebox _Services_Mid_" value="' + services_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Mid_" title="Staff">\
                    <div class="item_Label staff_mid" style="display:none;"> Staff: </div>\
                    <div id="eefStaff_Mid" class="signatureField" onclick="signature.payscale.select(\'Staff\',\'staff\',\'staff_mid\',\'signature_' + i + '_Staff_Mid\',\'label_' + i + '_Staff_Mid_\',\'staff_label_first_last\');">\
                    	<span id="label_' + i + '_Staff_Mid_">Staff</span>\
                        <input name="Staff_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Mid" class="resolvethisid signaturebox _Staff_Mid_" value="' + staff_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Value">\
                    <div id="label_' + i + '_Dvalue" class="itemLabel dvalue" onclick="signature.payscale.doThisWhenDone(\'field_focus\', 8000, signature.payscale.formBlur);signature.payscale.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Dvalue"> Value: </div>\
                    <div id="eefDvalue" class="signatureField">\
                        <input name="Dvalue_' + i + '" type="text" id="signature_' + i + '_Dvalue" class="signaturebox _Dvalue_" value="' + dvalue + '" style="display:none;"  relatedfield="label_' + i + '_Dvalue" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.payscale.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.payscale.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.payscale.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.payscale.records.length; i++){

                if (signature.payscale.records[i].action_del === 'N') {
                    if (signature.payscale.isChild) {
                        if (signature.payscale.parent === signature.payscale.records[i][signature.payscale.px]) {
                            signature.payscale.htmlRow(i, signature.payscale.records[i].field_id, signature.payscale.records[i].guid, signature.payscale.records[i].payscale_services_mid, signature.payscale.records[i].payscale_staff_mid, signature.payscale.records[i].payscale_dvalue, signature.payscale.records[i].payscale_status);
                        }

                    } else {
                        signature.payscale.htmlRow(i, signature.payscale.records[i].field_id, signature.payscale.records[i].guid, signature.payscale.records[i].payscale_services_mid, signature.payscale.records[i].payscale_staff_mid, signature.payscale.records[i].payscale_dvalue, signature.payscale.records[i].payscale_status);
                    }
                    
                    // signature.payscale.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.payscale.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.payscale.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.payscale.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.payscale.doThisWhenDone('field_focus', 8000, signature.payscale.formBlur);signature.payscale.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.payscale.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.payscale.sectionlabel+'</div>');
        
        signature.payscale.toggleSwitches();
        signature.payscale.resolveids();
        signature.payscale.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.payscale.runDoThis(myLabel); }, waitforAbout);

        // signature.payscale.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i].action_del === 'N') {
                    if (signature.payscale.records[i][theKey1] === guid) {
                        signature.payscale.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.payscale.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i].action_del === 'N') {
                    if (signature.payscale.records[i][theKey1] === search1 && signature.payscale.records[i][theKey2] === search2) {
                        signature.payscale.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.payscale.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i].action_del === 'N') {
                    if (signature.payscale.records[i][theKey1] === search1 && signature.payscale.records[i][theKey2] === search2 && signature.payscale.records[i][theKey3] === search3) {
                        signature.payscale.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.payscale.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i][theKey1] === search1 && signature.payscale.records[i][theKey2] === search2) {
                    var result = signature.payscale.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.payscale.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i][theKey1] === guid) {
                    var result = signature.payscale.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.payscale.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.payscale.records.length > 0) {

            var keys = Object.keys(signature.payscale.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.payscale.records.length; i++){
                if (signature.payscale.records[i].guid === guid) {
                    var result = signature.payscale.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.payscale.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';


signature.schedule = {
    records: [],
    update: [],
    list: [],
    isLoading: false,
    isChild: false,
    parent: '',
    px: '',
    valid: 1,
    sectionlabel: 'Schedule',
    fieldprefix: 'schedule_',
    del: function(i) {
        try {signature.schedule.records[i].schedule_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
        try {signature.schedule.records[i].schedule_wd = $('#signature_' + i + '_Wd').val();} catch (err) { }
        try { $('#label_' + i + '_Wd').text(signature.schedule.records[i].schedule_wd); } catch (err) { }
        try {signature.schedule.records[i].schedule_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
        try { $('#label_' + i + '_Epoch').text(signature.schedule.records[i].schedule_epoch); } catch (err) { }
        try {signature.schedule.records[i].schedule_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
        try { $('#label_' + i + '_Woy').text(signature.schedule.records[i].schedule_woy); } catch (err) { }
        try {signature.schedule.records[i].schedule_hours = $('#signature_' + i + '_Hours').val();} catch (err) { }
        try { $('#label_' + i + '_Hours').text(signature.schedule.records[i].schedule_hours); } catch (err) { }
        try {signature.schedule.records[i].schedule_status = $('#signature_' + i + '_Status').val();} catch (err) { }


        signature.schedule.records[i].action_del = 'Y';
        $('#row_' + i).remove();
        $("#unDelete").css('display','inline-block');
        var ix = 0;
        for (var iy = signature.schedule.records.length - 1; iy >= 0; iy--) {
            if (signature.schedule.records[iy].action_del === 'N') {
                ix++;
            }
        }
    }, //==============================================
    listAdd: function(i) {
        if (!signature.schedule.isLoading && !signature.schedule.list.includes(i)) {
            signature.schedule.list.push(i);
            // console.log(i);
        }
        // signature.schedule.listAdd(i)
    }, //==============================================
    dataIn: function() {
        signature.staffType.records = signature.v.tables.staffType;
        signature.category.records = signature.v.tables.category;
        signature.staff.records = signature.v.tables.staff;
        signature.services.records = signature.v.tables.services;
        signature.weeks.records = signature.v.tables.weeks;
        signature.weekItems.records = signature.v.tables.weekItems;
        signature.payscale.records = signature.v.tables.payscale;
        signature.schedule.records = signature.v.tables.schedule;

    }, //==============================================
    dataOut: function() {
        signature.v.tables = {};
        signature.v.tables['staffType'] = signature.staffType.records;
        signature.v.tables['category'] = signature.category.records;
        signature.v.tables['staff'] = signature.staff.records;
        signature.v.tables['services'] = signature.services.records;
        signature.v.tables['weeks'] = signature.weeks.records;
        signature.v.tables['weekItems'] = signature.weekItems.records;
        signature.v.tables['payscale'] = signature.payscale.records;
        signature.v.tables['schedule'] = signature.schedule.records;

        return signature.v.tables;
    }, //==============================================
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        signature.v.save = '';
        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';
        var result = signature.schedule.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.schedule.displayweek();
        // signature.schedule.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.schedule.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.schedule.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.schedule.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.schedule.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');


        signature.v.unspecificpost = 'signature.special.loadWeekItems();';
        // signature.v.unspecificpost = 'alert(signature.schedule.epochresolve(signature.v.selecteddate,\'string\') +" "+ signature.v.selecteddate +" "+ signature.schedule.resolveidunspecific(signature.v.selectedguid));';

        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.schedule.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.schedule.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        try {
            if (signature.v.cal_script.length > 0) {
                eval(signature.v.cal_script);
            } else {
            }
        } catch (err) {console.log('error');}



        signature.v.unbind += '$(document).off("keydown");';


        $('#arrowcontrol').html('<script>\n\
            $(document).off("keydown");\
            $(document).keydown(function(e){\n\
                if( e.which === 39 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.schedule.weekup();\n\
                     // console.log("control + right arrow");\n\
                  }\n\
                \n\
                if( e.which === 37 && e.ctrlKey ){\n\
                    event.preventDefault();\n\
                    signature.schedule.weekdown();\n\
                     // console.log("control + left arrow");\n\
                  }\n\
            });\n\
            </script>');

    },//==============================================
    refreshselectionunspecific: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpageunspecific: function(search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+signature.schedule.sectionlabel+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        // var labels = [];
        try {
            for (var ii = 0; ii < signature.staff.records.length; ii++) {
                var firstX = true;
                for (var i = 0; i < signature.schedule.records.length; i++) {
                    if (signature.schedule.records[i][signature.schedule.fieldprefix+'status'] === '1' && signature.staff.records[ii].guid == signature.schedule.records[i].schedule_staff_mid) {
                        if (search.length > 0) {
                            if (signature.schedule.records[i]['label'].toLowerCase().includes(search.toLowerCase())) {
                                if (firstX) {
                                    var firstX = false;
                                    $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                                }
                                $('#selectsomething .items').append('<div class="item" guid="'+signature.schedule.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.schedule.records[i]['label']+'</div>');
                            }
                        } else {
                            if (firstX) {
                                var firstX = false;
                                $('#selectsomething .items').append('<div class="grouplabel" style="text-align: left; font-size: 80%; font-weight: 700;">'+signature.staff.records[ii]['label']+'</div>');
                            }
                            $('#selectsomething .items').append('<div class="item" guid="'+signature.schedule.records[i]['guid']+'" onclick="signature.v.selectedguid=$(this).attr(\'guid\');$(\'#selectsomething\').remove();eval(signature.v.unspecificpost);">'+signature.schedule.records[i]['label']+'</div>');
                        }
                        // labels.push({'label':signature.schedule.records[i]['label'], 'guid':signature.schedule.records[i]['guid'], });
                    }
                }
            }
        } catch(err) {}

        // for (var i = 0; i < labels.length; i++) {}
        if (signature.schedule.records.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.schedule.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.schedule.selectpageunspecific(\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.schedule.doThisWhenDone("autosearch", 200, signature.schedule.refreshselectionunspecific);});</script>');        
            $('#selectsearch').focusTextToEnd();
        }
    }, //==============================================
    manage: function() {
        signature.v.area = 'schedule';
        if (signature.v.save.length > 0) {
            var valid = eval(signature.v.save);
            if (!valid) {return false;}
        }
        if (signature.v.initialload) {
            signature.v.save = 'signature.schedule.varUpdate();';
        } else {
            signature.v.save = 'signature.schedule.send();';
        }

        if (signature.v.unbind.length > 0) {
            eval(signature.v.unbind);
        }
        signature.v.unbind = '';


        signature.schedule.isLoading = true;
        


        if (signature.schedule.isChild) {
            var data = {"field_id":"","label":"","guid":signature.schedule.guid(),"schedule_staff_mid":"","schedule_wd":"","schedule_epoch":"","schedule_woy":"","schedule_hours":"","schedule_status":"1","action_del":"N"};
            var keys = Object.keys(data);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes('_id') && keys[i] !== 'field_id') {
                    signature.schedule.px = keys[i];
                }
            }
        }

        $('#manage').css('text-align','left');
        $('#manage').css('padding','200px');
        $('#manage').html('');
        if (signature.schedule.records.length === 0) {
            signature.schedule.add();
        } else {
            signature.schedule.buildPageFromJSON();
        }
        if (signature.v.manage_script.length > 0) {
            var valid = eval(signature.v.manage_script);
        }
        
        // signature.schedule.update = JSON.stringify(signature.schedule.records);
        // console.log('test');
        // signature.schedule.manage();
    }, //==============================================
    add: function() {
        var data = {"field_id":"","label":"","guid":signature.schedule.guid(),"schedule_staff_mid":"","schedule_wd":"","schedule_epoch":"","schedule_woy":"","schedule_hours":"","schedule_status":"1","action_del":"N"};

        signature.schedule.varUpdate();
        signature.schedule.records.push(data);
        signature.schedule.buildPageFromJSON();
        return data
    }, //==============================================
    add2: function() {
        var data = {"field_id":"","label":"","guid":signature.schedule.guid(),"schedule_staff_mid":"","schedule_wd":"","schedule_epoch":"","schedule_woy":"","schedule_hours":"","schedule_status":"1","action_del":"N"};

        signature.schedule.records.push(data);
        return data
    }, //==============================================
    varUpdate: function(id,tog) {
        try {
            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.hasFields()) {
                    try {if (signature.schedule.records[i].schedule_staff_mid !== $('#signature_' + i + '_Staff_Mid').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {if (signature.schedule.records[i].schedule_wd !== $('#signature_' + i + '_Wd').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_wd = $('#signature_' + i + '_Wd').val();} catch (err) { }
                    try { $('#label_' + i + '_Wd').text(signature.schedule.records[i].schedule_wd); } catch (err) { }
                    try {if (signature.schedule.records[i].schedule_epoch !== $('#signature_' + i + '_Epoch').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.schedule.records[i].schedule_epoch); } catch (err) { }
                    try {if (signature.schedule.records[i].schedule_woy !== $('#signature_' + i + '_Woy').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.schedule.records[i].schedule_woy); } catch (err) { }
                    try {if (signature.schedule.records[i].schedule_hours !== $('#signature_' + i + '_Hours').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_hours = $('#signature_' + i + '_Hours').val();} catch (err) { }
                    try { $('#label_' + i + '_Hours').text(signature.schedule.records[i].schedule_hours); } catch (err) { }
                    try {if (signature.schedule.records[i].schedule_status !== $('#signature_' + i + '_Status').val()){signature.schedule.listAdd(i);} } catch (err) { }
                    try {signature.schedule.records[i].schedule_status = $('#signature_' + i + '_Status').val();} catch (err) { }

                }
            }
        } catch (err) {}
//         try {
//             for(var i = 0;i < signature.schedule.records.length; i++){
//                 if (signature.schedule.hasFields()) {
// [js_HTML_ROW_Val_DEL]
//                 }
//             }
//         } catch (err) {}
        // console.log(signature.schedule.records);
        return true;
    }, //==============================================
    togglerow: function(id,tog) {
        if (!tog) {
            ans = confirm('Restore?');
        } else {
            ans = confirm('Used?');
        }
        if (ans) {
            window.location.href = '?id=' + id + '&toggle='+tog+'&manage';
        }
    }, //==============================================
    auto_valid: function() {
        var valid = true;
        var ix = 0
        try {
            for (var iy = signature.schedule.records.length - 1; iy >= 0; iy--) {
                if (signature.schedule.records[iy].action_del === 'N') {
                    ix++;
                }
            }
        } catch (err) {}
        try {
            for (var i = 0; i < signature.schedule.records.length; i++) {
                try {
                    if (signature.schedule.records[i].action_del === 'N') {

                        var item = '#signature_' + i + '_Staff_Mid';
                        if ($(item).val().length && $(item).val() !== 'Staff') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Wd';
                        if ($(item).val().length && $(item).val() !== 'Wd') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Epoch';
                        if ($(item).val().length && $(item).val() !== 'Epoch') {
                            $(item).parent().parent().css('border-color','');
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Woy';
                        if ($(item).val().length > 0  && $(item).val() !== 'Woy') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Hours';
                        if ($(item).val().length > 0  && $(item).val() !== 'Hours') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                        var item = '#signature_' + i + '_Status';
                        if ($(item).val().length > 0  && $(item).val() !== 'Status') {
                            if(isNaN($(item).val())){
                                $(item).parent().parent().css('border-color','crimson');
                                valid = false
                            } else {
                                $(item).parent().parent().css('border-color','');
                            }
                        } else {
                            $(item).parent().parent().css('border-color','crimson');
                            valid = false;
                        }

                    }
                } catch (err) {}
            }
        } catch (err) {}
        return valid
    }, //==============================================
    excel: function() {
        signature.schedule.download('excel.php','certificates.csv');
    }, //==============================================
    download: function(uri, filename) {
        var link = document.createElement('a');
        if (typeof link.download === 'string') {
            document.body.appendChild(link);
            link.download = filename;
            link.href = uri;
            link.click();
            document.body.removeChild(link);
        } else {
            location.replace(uri);
        }
    }, //==============================================
    shouldUpdate: function() {
        var one = JSON.stringify(signature.schedule.records);
        var two = signature.schedule.update;
        if (one === two) {
            var result = false;
        } else {
            var result = true;
        }

        return result;
    }, //==============================================
    send: function() {
        // if (signature.schedule.valid()) {
            signature.schedule.varUpdate();
            if (eval(signature.schedule.valid)) {
                if ( signature.schedule.list.length > 0) {
                    // console.log('update');
                    $('body').append(signature.v.loader);
                    /*
                    for (var i = 0; i < signature.schedule.records.length; i++) {
                        try {
                            try {signature.schedule.records[i].schedule_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.schedule.records[i].schedule_wd = $('#signature_' + i + '_Wd').val();} catch (err) { }
                    try { $('#label_' + i + '_Wd').text(signature.schedule.records[i].schedule_wd); } catch (err) { }
                    try {signature.schedule.records[i].schedule_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.schedule.records[i].schedule_epoch); } catch (err) { }
                    try {signature.schedule.records[i].schedule_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.schedule.records[i].schedule_woy); } catch (err) { }
                    try {signature.schedule.records[i].schedule_hours = $('#signature_' + i + '_Hours').val();} catch (err) { }
                    try { $('#label_' + i + '_Hours').text(signature.schedule.records[i].schedule_hours); } catch (err) { }
                    try {signature.schedule.records[i].schedule_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                        } catch (err) {}
                    }
                    */
                    var sendThisData = [];
                    for (var i = 0; i < signature.schedule.list.length; i++) {
                        sendThisData.push(signature.schedule.records[signature.schedule.list[i]]);
                    }
                    
                    $('#JSON').val(JSON.stringify(sendThisData));
                    // console.log($('#JSON').val());
                    // $.post("processSchedule.php", $("#form").serialize())
                    $.post("processSchedule.php", $("#manageForm").serialize())
                        .done(function(data) {
                            // if (data.toLowerCase().includes('unable')) {
                            if (data.length > 0) {
                                if (confirm('Save Error: try again?')) { signature.schedule.send(); }
                            } else {
                                signature.schedule.list = [];
                            }
                            console.log(data);
                            // console.log();
                            // try {
                            //     signature.schedule.records = JSON.parse(data)


                            // } catch (err) {
                            //     alert('Error');
                            // }
                            $('#loading').remove();
                            // signature.schedule.update = JSON.stringify(signature.schedule.records);
                        });
                    
                }
                return true;
            } else {
                return false;
            }
            // if ( signature.schedule.shouldUpdate() ) {
            // signature.schedule.thisweek();
        // }
        // signature.schedule.send();
    }, //==============================================
    loadJSON: function() {
        if (signature.shared.isLoaded(3)) {
            signature.schedule.buildPageFromJSON();
        } else {
            setTimeout(function() { signature.schedule.loadJSON(); }, 800);
        }
    },//==============================================
    unDelete: function() {
        $("#unDelete").css('display','none');
        for (var i = 0; i < signature.schedule.records.length; i++) {
            try {
                    try {signature.schedule.records[i].schedule_staff_mid = $('#signature_' + i + '_Staff_Mid').val();} catch (err) { }
                    try {signature.schedule.records[i].schedule_wd = $('#signature_' + i + '_Wd').val();} catch (err) { }
                    try { $('#label_' + i + '_Wd').text(signature.schedule.records[i].schedule_wd); } catch (err) { }
                    try {signature.schedule.records[i].schedule_epoch = $('#signature_' + i + '_Epoch').val();} catch (err) { }
                    try { $('#label_' + i + '_Epoch').text(signature.schedule.records[i].schedule_epoch); } catch (err) { }
                    try {signature.schedule.records[i].schedule_woy = $('#signature_' + i + '_Woy').val();} catch (err) { }
                    try { $('#label_' + i + '_Woy').text(signature.schedule.records[i].schedule_woy); } catch (err) { }
                    try {signature.schedule.records[i].schedule_hours = $('#signature_' + i + '_Hours').val();} catch (err) { }
                    try { $('#label_' + i + '_Hours').text(signature.schedule.records[i].schedule_hours); } catch (err) { }
                    try {signature.schedule.records[i].schedule_status = $('#signature_' + i + '_Status').val();} catch (err) { }


                signature.schedule.records[i].action_del = 'N';
            } catch(err) {
                signature.schedule.records[i].action_del = 'N';
            }
        }
        //signature.schedule.records = JSON.parse(signature.v.recover);
        signature.schedule.buildPageFromJSON();
    },//==============================================
    hasFields: function() {
        var result = false;
        for (var i = 0; i < signature.schedule.records.length; i++) {
            if ( $( '#signature_' + i + '_Wd' ).length ) {
                result = true;
            }
        }
        return result;
        // 
    },//==============================================
    resolveidunspecific: function(id) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        return label;
        // signature.schedule.resolveids();
    },//==============================================
    resolveid: function(idx,id,labelid) {
        // console.log(idx+' - '+labelid+' - '+id);
        var found = false;
        var label = '';
        if (id.length > 0) {

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staffType.records.length; i++) {
	        			if (signature.staffType.records[i].guid === id) {
	        				label = signature.staffType.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.category.records.length; i++) {
	        			if (signature.category.records[i].guid === id) {
	        				label = signature.category.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.staff.records.length; i++) {
	        			if (signature.staff.records[i].guid === id) {
	        				label = signature.staff.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

	        try {
	        	if (!found) {
	        		for (var i = 0; i < signature.services.records.length; i++) {
	        			if (signature.services.records[i].guid === id) {
	        				label = signature.services.records[i]['label'];
	        				found = true;
	        			}
	        		}
	        	}
	        } catch(err) {}

        }
        // console.log(found,label);
        if (found) {
            $('#'+labelid).text(label);
        }
        // signature.schedule.resolveids();
    },//==============================================
    resolveids: function() {
        $('.resolvethisid').each(function( index ) {
            signature.schedule.resolveid($(this).parent().parent().parent().attr('idx'),$(this).val(),$(this).parent().parent().attr('findlabel'))
        });
    },//==============================================
    formBlur: function() {
        // console.log('formBlur');
        if (signature.v.area !== 'timelog') {
            if ( $('#'+signature.v.lastID).hasClass('_Staff_Mid_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Staff') }
            if ( $('#'+signature.v.lastID).hasClass('_Wd_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Wd') }
            if ( $('#'+signature.v.lastID).hasClass('_Epoch_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Epoch') }
            if ( $('#'+signature.v.lastID).hasClass('_Woy_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Woy') }
            if ( $('#'+signature.v.lastID).hasClass('_Hours_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Hours') }
            if ( $('#'+signature.v.lastID).hasClass('_Status_') && $('#'+signature.v.lastID).val() === '') { $('#'+signature.v.lastID).val('Status') }

            signature.schedule.varUpdate();
            $('.itemLabel').css('display','inline-block');
            $('input').css('display','none');
        }
    },//==============================================
    toggleSwitches: function() {
        signature.schedule.varUpdate();
        for (var i = 0; i < signature.schedule.records.length; i++) {
            try {
                if (signature.schedule.records[i].action_del === 'N') {
                    try {signature.schedule.records[i].schedule_status = $('#signature_' + i + '_Status').val();} catch (err) { }
                    if (signature.schedule.records[i].schedule_status === '1') {$('#toggle_' + i + '_Status_on').css('display','inline-block');$('#toggle_' + i + '_Status_off').css('display','none');} else {$('#toggle_' + i + '_Status_on').css('display','none');$('#toggle_' + i + '_Status_off').css('display','inline-block');}

                }

            } catch(err) {}
        }
    },//==============================================
    toggle: function(p,field,vid,lid) {
        // console.log($('#'+vid).val());
        if ($('#'+vid).val() === '1') {
            $('#'+vid).val(0);
            $('#'+p+' .toggleOn').css('display','none');
            $('#'+p+' .toggleOff').css('display','inline-block');
        } else {
            $('#'+vid).val(1);
            $('#'+p+' .toggleOn').css('display','inline-block');
            $('#'+p+' .toggleOff').css('display','none');
        }
    },//==============================================
    selected: function(i,label,tbl,field,vid,lid,tableLabel) {
        $('#selectsomething').remove();
        $('#'+vid).val(signature.schedule.records[i]['guid'])
        $('#'+lid).text(signature.schedule.records[i]['label']);
    },//==============================================
    refreshselection: function() {
        // console.log(signature.v.searchfor);
        var action = signature.v.refreshaction.replace('SEARCHHERE',signature.v.searchfor);
        // console.log(action);
        eval(action);
    },//==============================================
    selectpage: function(label,tbl,field,vid,lid,tableLabel,search) {
        $('#selectsomething').remove();
        $('body').append('<div id="selectsomething"><span class="close" onClick="$(\'#selectsomething\').remove();">X</span><div id="selectsomethinginner"><span id="selectheader">'+label+'</span><hr /><input type="text" id="selectsearch" value="'+search+'"><br /><div class="items"></div></div></div>');
        var labels = [];
        try {
            for (var i = 0; i < signature.schedule.records.length; i++) {
                if (signature.schedule.records[i][signature.schedule.fieldprefix+'status'] === '1') {
                    labels.push(signature.schedule.records[i]['label']);
                }
            }
        } catch(err) {}
        for (var i = 0; i < labels.length; i++) {
            if (search.length > 0) {
                if (labels[i].includes(search)) {
                    $('#selectsomething .items').append('<div class="item" onclick="signature.schedule.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
                }
            } else {
                $('#selectsomething .items').append('<div class="item" onclick="signature.schedule.selected(\''+i+'\',\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\');">'+labels[i]+'</div>');
            }
        }
        if (labels.length === 0) {
            $('#selectsomething .items').append('<div class="item" >No Records</div>');
            $('#selectsomething .items').append('<div class="item" ></div>');
            $('#selectsomething .items').append('<div class="item button" onClick="signature.schedule.manage();$(\'#selectsomething\').remove();">Add Record</div>');
            $('#selectsearch').remove();
        } else {
            signature.v.refreshaction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'SEARCHHERE\');';
            $('#selectsomething').append('<script>$("#selectsearch").keyup(function() {signature.v.searchfor = $("#selectsearch").val();signature.schedule.doThisWhenDone("autosearch", 200, signature.schedule.refreshselection);});</script>');
            $('#selectsearch').focusTextToEnd();
        }
    },//==============================================
    select: function(label,tbl,field,vid,lid,tableLabel) {
        // alert(label+' '+tbl);
        // console.log('1');
        var taskAction = 'signature.'+tbl+'.selectpage(\''+label+'\',\''+tbl+'\',\''+field+'\',\''+vid+'\',\''+lid+'\',\''+tableLabel+'\',\'\');';
        // console.log('2');
        eval(taskAction);
        // console.log(taskAction)
        // console.log('3');
    },//==============================================
    formFocus: function(idx,id) {
        signature.v.lastID = id;
        signature.v.lastIDX = idx;
        if ('signature_'+idx+'_Staff_Mid' === id && $('#'+id).val() === 'Staff') { $('#'+id).val('') }
        if ('signature_'+idx+'_Wd' === id && $('#'+id).val() === 'Wd') { $('#'+id).val('') }
        if ('signature_'+idx+'_Epoch' === id && $('#'+id).val() === 'Epoch') { $('#'+id).val('') }
        if ('signature_'+idx+'_Woy' === id && $('#'+id).val() === 'Woy') { $('#'+id).val('') }
        if ('signature_'+idx+'_Hours' === id && $('#'+id).val() === 'Hours') { $('#'+id).val('') }
        if ('signature_'+idx+'_Status' === id && $('#'+id).val() === 'Status') { $('#'+id).val('') }

    },//==============================================
    managechildren: function(guid) {
        // console.log(guid);
        // $('.thechild').remove();
        // $('.managechildrenbutton').remove();
        // $('.certItemParent').each(function( index ) {
        //     console.log('each - '+$(this).attr('guid'));
        //     if ($(this).attr('guid') !== guid) {
        //         console.log('not match');
        //         $(this).remove();
        //     }
        // });
        // $("[guid='"+guid+"']").append('<div class="thechild"></div>');
        


        // console.log('done');
    },//==============================================
    saveThenOpen: function() {
        signature.shared.close();
        signature.shared.runWhen(null, 'closed', function(){signature.schedule.obj.edit();});
    }, //==============================================
    htmlRow: function(i, id, guid, staff_mid, wd, epoch, woy, hours, status) {
            if (typeof i === 'undefined') {
                i = signature.schedule.records.length - 1;
            }
            if (typeof id === 'undefined') {
                id = 0;
            }
            
            if (typeof staff_mid === 'undefined') { staff_mid = ''; }
            if (typeof wd === 'undefined') { wd = ''; }
            if (typeof epoch === 'undefined') { epoch = ''; }
            if (typeof woy === 'undefined') { woy = ''; }
            if (typeof hours === 'undefined') { hours = ''; }
            if (typeof status === 'undefined') { status = '1'; }


            if (staff_mid === '') { staff_mid = 'Staff'; }
            if (wd === '') { wd = 'Wd'; }
            if (epoch === '') { epoch = 'Epoch'; }
            if (woy === '') { woy = 'Woy'; }
            if (hours === '') { hours = 'Hours'; }
            if (status === '') { status = 'Status'; }


            $('#manage').append('\
            <div id="row_' + i + '" class="certItemParent certItem" idx="' + i + '" guid="' + guid + '" onblur="$(\'.morebutton\').css(\'display\',\'inline-block\');$(\'.more\').css(\'display\',\'none\');">\
                <div id="eDelete' + i + '" class="eDelete" title="delete" onClick="signature.schedule.del(' + i + ');">\
                   <img src="images/delete.png">\
                </div>\
                <div class="signatureItem" findlabel="label_' + i + '_Staff_Mid_" title="Staff">\
                    <div class="item_Label staff_mid" style="display:none;"> Staff: </div>\
                    <div id="eefStaff_Mid" class="signatureField" onclick="signature.schedule.select(\'Staff\',\'staff\',\'staff_mid\',\'signature_' + i + '_Staff_Mid\',\'label_' + i + '_Staff_Mid_\',\'staff_label_first_last\');">\
                    	<span id="label_' + i + '_Staff_Mid_">Staff</span>\
                        <input name="Staff_Mid_' + i + '" type="hidden" id="signature_' + i + '_Staff_Mid" class="resolvethisid signaturebox _Staff_Mid_" value="' + staff_mid + '">\
                    </div>\
                </div>\
                <div class="signatureItem" title="Wd">\
                    <div id="label_' + i + '_Wd" class="itemLabel wd" onclick="signature.schedule.doThisWhenDone(\'field_focus\', 8000, signature.schedule.formBlur);signature.schedule.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Wd"> Wd: </div>\
                    <div id="eefWd" class="signatureField">\
                        <input name="Wd_' + i + '" type="text" id="signature_' + i + '_Wd" class="signaturebox _Wd_" value="' + wd + '" style="display:none;"  relatedfield="label_' + i + '_Wd" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Epoch">\
                    <div id="label_' + i + '_Epoch" class="itemLabel epoch" onclick="signature.schedule.doThisWhenDone(\'field_focus\', 8000, signature.schedule.formBlur);signature.schedule.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Epoch"> Epoch: </div>\
                    <div id="eefEpoch" class="signatureField">\
                        <input name="Epoch_' + i + '" type="text" id="signature_' + i + '_Epoch" class="signaturebox _Epoch_" value="' + epoch + '" style="display:none;"  relatedfield="label_' + i + '_Epoch" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Woy">\
                    <div id="label_' + i + '_Woy" class="itemLabel woy" onclick="signature.schedule.doThisWhenDone(\'field_focus\', 8000, signature.schedule.formBlur);signature.schedule.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Woy"> Woy: </div>\
                    <div id="eefWoy" class="signatureField">\
                        <input name="Woy_' + i + '" type="text" id="signature_' + i + '_Woy" class="signaturebox _Woy_" value="' + woy + '" style="display:none;"  relatedfield="label_' + i + '_Woy" >\
                    </div>\
                </div>\
                <div class="signatureItem" title="Hours">\
                    <div id="label_' + i + '_Hours" class="itemLabel hours" onclick="signature.schedule.doThisWhenDone(\'field_focus\', 8000, signature.schedule.formBlur);signature.schedule.varUpdate();$(\'.itemLabel\').css(\'display\',\'inline-block\');$(\'input\').css(\'display\',\'none\');$(\'#\'+$(this).attr(\'relatedfield\')).css(\'display\',\'inline-block\');$(this).css(\'display\',\'none\');" relatedfield="signature_' + i + '_Hours"> Hours: </div>\
                    <div id="eefHours" class="signatureField">\
                        <input name="Hours_' + i + '" type="text" id="signature_' + i + '_Hours" class="signaturebox _Hours_" value="' + hours + '" style="display:none;"  relatedfield="label_' + i + '_Hours" >\
                    </div>\
                </div>\
                <div class="signatureItem">\
                    <div class="item_Label status" style="display:none;"> Status: </div>\
                    <div id="eefStatus_' + i + '_" class="signatureField thetoggle" relatedfield="label_' + i + '_Status_" onclick="signature.schedule.toggle(\'eefStatus_' + i + '_\',\'status\',\'signature_' + i + '_Status\',\'label_' + i + '_Status_\');"><span id="label_' + i + '_Status_" class="togglelabel" style="display:none;">Status</span>\
                        <img src="images/toggle_on.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_on" class="toggleOn">\
                        <img src="images/toggle_off.png" style="height:23px;width: 50px; display:none;" id="toggle_' + i + '_Status_off" class="toggleOff">\
                        <input name="Status_' + i + '" type="hidden" id="signature_' + i + '_Status" class="signaturebox _Status_" value="' + status + '">\
                    </div>\
                </div>\
                <br />\
                <div id="someSpace"></div>\
                \
            </div>\
            <input name="id_' + i + '" type="hidden" id="id_' + i + '" value="' + id + '"/>');
                // <div class="thechild"></div>\
    }, //==============================================
    buildPageFromJSON: function() {
        // signature.schedule.varUpdate();
        // console.log('buildPageFromJSON');
        //signature.v.recover = JSON.stringify(signature.schedule.records);
        $('#manage').html('');

        try {
            for(var i = 0;i < signature.schedule.records.length; i++){

                if (signature.schedule.records[i].action_del === 'N') {
                    if (signature.schedule.isChild) {
                        if (signature.schedule.parent === signature.schedule.records[i][signature.schedule.px]) {
                            signature.schedule.htmlRow(i, signature.schedule.records[i].field_id, signature.schedule.records[i].guid, signature.schedule.records[i].schedule_staff_mid, signature.schedule.records[i].schedule_wd, signature.schedule.records[i].schedule_epoch, signature.schedule.records[i].schedule_woy, signature.schedule.records[i].schedule_hours, signature.schedule.records[i].schedule_status);
                        }

                    } else {
                        signature.schedule.htmlRow(i, signature.schedule.records[i].field_id, signature.schedule.records[i].guid, signature.schedule.records[i].schedule_staff_mid, signature.schedule.records[i].schedule_wd, signature.schedule.records[i].schedule_epoch, signature.schedule.records[i].schedule_woy, signature.schedule.records[i].schedule_hours, signature.schedule.records[i].schedule_status);
                    }
                    
                    // signature.schedule.htmlRow(i, field_id, first, last, email, certificate, cnt, dvalue, status);
                }
            }
        } catch (err) {}
        signature.schedule.varUpdate();
        $('.add').remove();
        $('.save').remove();
        $('#manage').append('<br /><br /><br />');
        $('#manage').append('<div class="button add" onclick="signature.schedule.add();">Add</div>');
        $('#manage').append('<div class="button save" onclick="signature.schedule.send();">Save</div>');
        $('#manage').append("<script>$( '.signaturebox' ).focus(function() { signature.schedule.doThisWhenDone('field_focus', 8000, signature.schedule.formBlur);signature.schedule.formFocus($(this).parent().parent().parent().attr('idx'),$(this).attr('id')); });</script>");
        $('#manage').append("<script>$( '.signaturebox' ).blur(function() { signature.schedule.formBlur(); });</script>");
        $('#manage').append("<script>$( '.thetoggle' ).hover( function() { $('#'+$(this).attr('relatedfield')).css('display','inline-block'); }, function() { $( '.togglelabel' ).css('display','none' ); } );</script>");
        $('#manage').prepend('<div id="thesection">'+signature.schedule.sectionlabel+'</div>');
        
        signature.schedule.toggleSwitches();
        signature.schedule.resolveids();
        signature.schedule.isLoading = false;
    }, //==============================================
    runDoThis: function(myLabel) {
        if (typeof signature.v.doThis !== 'undefined') {
            var nowish = start = new Date().getTime();
            var run = false;
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                var thisWait = signature.v.doThis[j].wait;
                var thisStamp = signature.v.doThis[j].stamp;
                if (myLabel === thisLabel) {

                    if ((nowish - thisStamp) > thisWait) {var checkStamp =  true;} else {var checkStamp =  false;}
                    if (checkStamp) {
                        var run = true;
                        var thisLabel = signature.v.doThis[j].myLabel;
                        var thisScript = signature.v.doThis[j].script;
                    }
                }
            }
        }
        if (run) {
            thisScript();
        }
    }, //==============================================
    doThisWhenDone: function(myLabel, waitfor, script) {
        var isNew = true;
        var isFirst = false;
        var stamp = start = new Date().getTime();
        if (typeof signature.v.doThis === 'undefined') {
            var nextID = 0
            signature.v.doThis = new Array();
            signature.v.doThis = [];
            signature.v.doThis.length = 0;
            var isFirst = true;
        } else {
            var nextID = signature.v.doThis.length;
        }
        if (!isFirst) {
            for (var j = 0; j < signature.v.doThis.length; j++) {
                var thisLabel = signature.v.doThis[j].myLabel;
                if (myLabel === thisLabel) {
                    var isNew = false;
                    signature.v.doThis[j] = {
                        myLabel: myLabel,
                        stamp: stamp,
                        wait: waitfor,
                        script: script
                    };
                }
            }
        }
        if (isNew) {

            signature.v.doThis[nextID] = {
                myLabel: myLabel,
                stamp: stamp,
                wait: waitfor,
                script: script
            };
        }
        var waitforAbout = waitfor + 50;
        setTimeout(function() { signature.schedule.runDoThis(myLabel); }, waitforAbout);

        // signature.schedule.doThisWhenDone(myLabel, waitfor, script);
    }, //==============================================
    updateField: function(field1,guid,field2,newValue) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i].action_del === 'N') {
                    if (signature.schedule.records[i][theKey1] === guid) {
                        signature.schedule.records[i][theKey2] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.schedule.updateField(field1,guid,field2,newValue)
    }, //==============================================
    updateFieldByTwo: function(field1,search1,field2,search2,field3,newValue) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }


            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i].action_del === 'N') {
                    if (signature.schedule.records[i][theKey1] === search1 && signature.schedule.records[i][theKey2] === search2) {
                        signature.schedule.records[i][theKey3] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.schedule.updateFieldByTwo(field1,search1,field2,search2,field3,newValue)
    }, //==============================================
    updateFieldByThree: function(field1,search1,field2,search2,field3,search3,field4,newValue) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
                if (keys[i].includes(field4) && keys[i] !== 'field_id') {
                    var theKey4 = keys[i];
                }
            }


            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i].action_del === 'N') {
                    if (signature.schedule.records[i][theKey1] === search1 && signature.schedule.records[i][theKey2] === search2 && signature.schedule.records[i][theKey3] === search3) {
                        signature.schedule.records[i][theKey4] = newValue;
                        var result = true;
                    }
                }
            }
            
        } else {
            var result = false;
        }
        
        
        return result;
        // signature.schedule.updateFieldByThree(field1,search1,field2,search2,field3,search3,field4,newValue)
    }, //==============================================
    getFieldByTwo: function(field1,search1,field2,search2,field3) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field3) && keys[i] !== 'field_id') {
                    var theKey3 = keys[i];
                }
            }
            // console.log(theKey1,theKey2,theKey3);

            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i][theKey1] === search1 && signature.schedule.records[i][theKey2] === search2) {
                    var result = signature.schedule.records[i][theKey3];
                    // console.log('found');
                }
            }
        } else {
            var result = 'error';
        }
        
        // console.log(result);
        return result;
        // signature.schedule.getFieldByTwo(field1,search1,field2,search2,field3)
    }, //==============================================
    getField2: function(field1,guid,field2) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field2) && keys[i] !== 'field_id') {
                    var theKey2 = keys[i];
                }
                if (keys[i].includes(field1) && keys[i] !== 'field_id') {
                    var theKey1 = keys[i];
                }
            }


            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i][theKey1] === guid) {
                    var result = signature.schedule.records[i][theKey2];
                }
            }
        } else {
            var result = 'No ' + signature.schedule.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    getField: function(guid,field) {
        var result = '';
        if (signature.schedule.records.length > 0) {

            var keys = Object.keys(signature.schedule.records[0]);
            for (var i = 0; i < keys.length; i++) {
                if (keys[i].includes(field) && keys[i] !== 'field_id') {
                    var theKey = keys[i];
                }
            }


            for(var i = 0;i < signature.schedule.records.length; i++){
                if (signature.schedule.records[i].guid === guid) {
                    var result = signature.schedule.records[i][theKey];
                }
            }
        } else {
            var result = 'No ' + signature.schedule.sectionlabel + ' Records';
        }
        
        
        return result;
    }, //==============================================
    guid: function() {
        function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
        }
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
    }, //==============================================
    nullFunction: function() {
        //signature.shared.log('null');
    } //==============================================
}
// signature.v.loader = '<div id="loading"><img src="images/dance.gif"></div>';
signature.v.loader = '<div id="loading"><img src="images/gears.gif"></div>';
signature.v.save = '';
signature.v.area = '';
