signature.scheduleCalendar = {
    ph: 0,
    weekDateToDate: function(year, week, day) {
      const firstDayOfYear = new Date(year, 0, 1);
      const days = 2 + day + (week - 1) * 7 - firstDayOfYear.getDay();
      return new Date(year, 0, days);
    }, //==============================================
    getWeekNumber: function(d) {
        d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate()));
        d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
        var yearStart = new Date(Date.UTC(d.getUTCFullYear(),0,1));
        var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
        return [d.getUTCFullYear(), weekNo];
        // return weekNo;
    }, //==============================================
    thisweek: function() {
        signature.v.area = 'weeks';

        
        var result = signature.scheduleCalendar.getWeekNumber(new Date());
        signature.v.week = result[1];
        signature.v.year = result[0];
        signature.scheduleCalendar.displayweek();
        // signature.scheduleCalendar.thisweek();
    }, //==============================================
    weekup: function() {
        if (signature.v.week === 52) {
            signature.v.week = 1;
            signature.v.year++;
        } else {
            signature.v.week ++;
        }
        
        signature.scheduleCalendar.displayweek();
    }, //==============================================
    weekdown: function() {
        if (signature.v.week === 1) {
            signature.v.week = 52;
            signature.v.year--;
        } else {
            signature.v.week --;
        }

        signature.scheduleCalendar.displayweek();
    }, //==============================================
    epochresolve: function(epoch,datestring) {
        var d = new Date(Number(epoch));
        if (datestring === 'string') {
            var thedate = d.toString().split(' ');
            var result = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
        } else {
            var result = d;
        }
        return result;
    }, //==============================================
    displayweek: function() {
        $('#manage').html('<div id="datearea"></div>');
        $('#datearea').append('<br /><br />');
        var ii = 0;
        // for (var i = 0; i < 7; i++) {
        for (var i = 2; i < 9; i++) {
            ii++;
            var thedate = signature.scheduleCalendar.weekDateToDate(signature.v.year,signature.v.week,i).toString().split(' ');
            var epoch = signature.scheduleCalendar.weekDateToDate(signature.v.year,signature.v.week,i).getTime();
            var displaydate = thedate[0]+' '+thedate[1]+' '+thedate[2]+' '+thedate[3];
            $('#datearea').append('<div id="date_'+i+'_day" class="dateitem" woy="'+signature.v.year.toString()+signature.v.week.toString()+'" epoch="'+epoch+'"><span class="datetitle" onclick="signature.v.selecteddate=\''+epoch+'\';signature.special.staffSchedule(\'\');">'+displaydate+'</span><div class="reportbutton button" onclick="signature.special.epochDateReportShow(this);" style="display:inline-block;margin:10px;"> view report  </div> <div class="close" onclick="signature.special.epochDateReportHide(this);" style="font-size: 120%; font-weight: bolder;color:crimson;display:none;padding:10px;">X</div><div class="dayreport" style="display:none;"></div></div>');
            // $('#manage').append('<div onclick="signature.v.selecteddate=\''+epoch+'\';signature.staff.selectpageunspecific(\'\');">'+displaydate+' epoch: '+epoch+'</div>');
            if ((ii) % 3 === 0) {
                $('#datearea').append('<span class="calpagebreak"><br /></span>');
            }
        }
            $('#datearea').append('<div id="date_'+i+'_day"  class="dateitemtotals" ><span class="datetitle" >Week Totals</span><div class="dayreport" ></div></div>');



        $('#manage').prepend('<div id="theweektotals"></div>');

        $('#manage').prepend('<div id="weeknav" style="padding-left: 50px;"></div>');
        $('#weeknav').prepend('<div><div class="button" onclick="signature.scheduleCalendar.weekdown()" style="padding: 5px">last week</div> &nbsp; <div class="button" onclick="signature.scheduleCalendar.weekup()" style="padding: 5px">next week</div></div>');
        $('#weeknav').prepend('<div style="padding:5px;">Week '+signature.v.week+'</div>');
        $('#manage').prepend('<div class="button" onClick="signature.scheduleCalendar.send();">Save</div><br /><br />');
        
        signature.v.imp_woy = signature.v.year.toString()+','+signature.v.week.toString();
        signature.v.weekepochlist = [];
        signature.v.imp_epoch = '';
        $('.dateitem').each(function( index ) {
            signature.v.weekepochlist.push($(this).attr('epoch'));
        });
        signature.v.imp_epoch = signature.special.implode(signature.v.weekepochlist,',');


        setTimeout(function(){signature.scheduleCalendar.loadSchedule();}, 200);
        setTimeout(function(){signature.scheduleCalendar.loadSchedule();}, 800);
    }, //==============================================
    loadSchedule: function() {
        $('.dateitem').each(function( index ) {
            var epoch = $(this).attr('epoch');
            $("[epoch='"+epoch+"'] .dayreport").html('');
            $("[epoch='"+epoch+"'] .dayreport").append(signature.scheduleCalendar.daySchedule(epoch));
        });
        $('#manage').append('<script>$(".staffHours").keyup(function() { signature.scheduleCalendar.fieldChange(this); });</script>');
        $('.reportbutton').text('edit schedule');
        $('#date_9_day').remove();
        // $('#date_9_day .dayreport').append(signature.scheduleCalendar.weekTotalsReport());
        // signature.scheduleCalendar.loadSchedule();
    }, //==============================================
    daySchedule: function(epoch) {
        var item = '';
        // try {
            if (signature.staff.records.length > 0) {
                for(var i = 0;i < signature.staff.records.length; i++) {
                    item += '<div class="persondata"  style="padding: 5px" xid="'+i+'" guid="'+signature.staff.records[i].guid+'" >';
                    var scheduleDefault = 0;
                    var scheduleSpecified = false;
                    var yid = '';
                    if (signature.schedule.records.length > 0) {
                        for(var ii = 0;ii < signature.schedule.records.length; ii++) {
                            if (signature.schedule.records[ii].schedule_staff_mid === signature.staff.records[i].guid && signature.schedule.records[ii].schedule_epoch === epoch) {
                                scheduleDefault = Number(signature.schedule.records[ii].schedule_hours);
                                yid = ii;
                                scheduleSpecified = true;
                            }
                        }
                    }

                    if (!scheduleSpecified && signature.staff.records[i].staff_availability_json !== '' && typeof signature.staff.records[i].staff_availability_json !== 'undefined') {
                        var wd = signature.scheduleCalendar.epochWeekDay(epoch);
                        console.log(signature.staff.records[i].staff_availability_json);
                        var schedule = JSON.parse(signature.staff.records[i].staff_availability_json);

                        scheduleDefault = Number(schedule[wd]);
                    }

                    item += '<input type="text" yid="'+yid+'" class="staffHours" value="'+scheduleDefault+'" def="'+scheduleDefault+'" style="width:30px;">';
                    item += '<span class="person" style="padding: 5px">'+signature.staff.records[i].label+'</span>';
                    item += '</div>';
                }
            }

        return item;
    }, //==============================================
    epochWeekDay: function(epoch) {
        epoch = Number(epoch);
        var thedate = signature.scheduleCalendar.epochresolve(epoch,'string').toString().split(' ');
        var displaydate = thedate[0];
        return displaydate.toLowerCase();
        // signature.scheduleCalendar.epochWeekDay(epoch)
    }, //==============================================
    fieldChange: function(that) {
        var goodData = true;
        try{ var test = Number($(that).val()); } catch (err) { var test = 0; goodData = false;}
        if (test < 0) {$(that).val('0');goodData = false;}
        if (isNaN($(that).val())) {$(that).val('0');goodData = false;}
        var xid = Number($(that).parent().attr('xid'));
        var yid = $(that).attr('yid');
        var guid = $(that).parent().attr('guid');
        var epoch = $(that).parent().parent().parent().attr('epoch');
        var woy = $(that).parent().parent().parent().attr('woy');
        var wd = signature.scheduleCalendar.epochWeekDay(epoch);

        if (goodData) {
            if (signature.staff.records[xid].staff_availability_json !== '' && typeof signature.staff.records[xid].staff_availability_json !== 'undefined') {
                var schedule = JSON.parse(signature.staff.records[xid].staff_availability_json);
                schedule[wd] = $(that).val();
                signature.staff.records[xid].staff_availability_json = JSON.stringify(schedule);
            } else {
                var schedule = signature.scheduleCalendar.genDays();
                schedule[wd] = $(that).val();
                signature.staff.records[xid].staff_availability_json = JSON.stringify(schedule);
            }
            if (yid.length > 0) {
                signature.schedule.records[Number(yid)].schedule_hours = $(that).val();
            } else {
                signature.scheduleCalendar.addSchedule(guid,epoch,wd,woy,$(that).val());
            }
            
        }

        if ($(that).val() === '0') {
            $("[epoch=\'"+epoch+"\'] [epoch=\'"+guid+"\'] ").css('text-decoration','line-through');
        } 
        
        // signature.scheduleCalendar.fieldChange(this);
    }, //==============================================
    addSchedule: function(staff_mid,epoch,wd,woy,hrs) {
        var data = {"field_id":"","label":"","guid":signature.schedule.guid(),"schedule_date_created":"","schedule_staff_mid":staff_mid,"schedule_wd":wd,"schedule_epoch":epoch,"schedule_woy":woy,"schedule_hours":hrs,"schedule_status":"1","action_del":"N"};

        signature.schedule.varUpdate();
        signature.schedule.records.push(data);
        // signature.schedule.buildPageFromJSON();
        return data
        // signature.scheduleCalendar.addSchedule(staff_mid,epoch,wd,woy,hrs);
    }, //==============================================
    genDays: function() {
        var result = [];
        var keys = {};
        for(var i = 0;i < signature.v.weekepochlist.length; i++) {
            var data = signature.scheduleCalendar.epochWeekDay(signature.v.weekepochlist[i]);
            result.push(data);
            keys[data] = 0;
        }
        // return signature.special.implode(result,',');
        return keys;
        // signature.scheduleCalendar.genDays();
    }, //==============================================
    send: function() {
        // console.log('sending');
        // console.log('Fix Send When Done');
        // return true;
        // if (signature.weekItems.valid()) {
            // signature.weekItems.varUpdate();
            // if ( signature.weekItems.shouldUpdate() ) {
            if ( signature.schedule.records.length > 0) {
                // console.log('update');
                $('body').append(signature.v.loader);

                var sendThisData = {};
                sendThisData['staff'] = signature.staff.records;
                sendThisData['schedule'] = signature.schedule.records;






                $('#JSON').val(JSON.stringify(sendThisData));
                var bytes = signature.special.lengthInUtf8Bytes($('#JSON').val());
                console.log(bytes,'bytes');
                console.log(bytes/1024,'KB');
                console.log((bytes/1024)/1024,'MB');
                // console.log($('#JSON').val());
                // $.post("processWeek_Items.php", $("#form").serialize())
                $.post("processSchedule2.php", $("#manageForm").serialize())
                    .done(function(data) {
                        // if (data.toLowerCase().includes('unable')) {
                        if (data.length > 0) {
                            if (confirm('Save Error: try again?')) { signature.scheduleCalendar.send(); }
                        }
                        console.log(data);

                        $('#loading').remove();
                    });
                
            }
            return true;
        // signature.scheduleCalendar.send();


    }, //==============================================
    scheduledHours: function(guid,epoch) {
        var result = '-';
        if (signature.schedule.records.length > 0) {
            for(var ii = 0;ii < signature.schedule.records.length; ii++) {
                if (signature.schedule.records[ii].schedule_staff_mid === guid && signature.schedule.records[ii].schedule_epoch === epoch) {
                    result = signature.schedule.records[ii].schedule_hours;
                }
            }
        }
        return result;
        // signature.scheduleCalendar.scheduledHours(guid,epoch);
    }, //==============================================
    scheduledHoursNote: function(guid,epoch) {
        return 'Scheduled: ' + signature.scheduleCalendar.scheduledHours(guid,epoch) + ' hrs';;
    }, //==============================================
    nullFunction: function() {

    } //==============================================
}