
## Chrome Extension
~~~json
    manifest.json
                {
                    "manifest_version": 2,
                    "name": "eye beta",
                    "version": "0.1",
                    "permissions": [
                        "tabs",
                        "http://*/*", 
                        "https://*/*",
                        "https://ext.eyeformeta.com/"
                    ],
                    "browser_action": {
                        "default_title": "meta manager",
                        "default_popup": "popup.htm",
                        "default_icon": "icon.png"
                    },
                    "content_scripts": [ {
                        "matches": [
                            "<all_urls>"
                        ],
                            "js": [
                                "content.js"
                            ]
                    }],
                    "background": {
                        "scripts": [
                            "background.js"
                        ]
                    }
                }

    content.js

                console.log('content.js - loaded');

                chrome.runtime.onMessage.addListener(gotMessage);

                function gotMessage(message,sender,sendResponse) {
                    console.log('message',message);
                    // if (message.txt == 'hello') { let paragraphs = document.getElementsByTagName('p'); for ( elt of paragraphs ) { elt.style['background-color'] = '#FF00FF'; } }
                }



                var pageURL = new URL( window.location.href );
                setTimeout(function() {
                    chrome.runtime.sendMessage({
                        action: 'load',
                        page: pageURL.hostname.replace('www.','').toLowerCase()+pageURL.pathname,
                        domain: pageURL.hostname.replace('www.','').toLowerCase(),

                    }, function(response) {
                        console.log('runtime.sendMessage','ran');
                        respondedWith = response;
                        console.log('sendMessage-respondedWith',respondedWith);
                    });
                }, 500);

    background.js
                console.log('background.js - loaded');

                chrome.browserAction.onClicked.addListener(buttonClicked);

                function buttonClicked(tab) {
                    let msg = {
                        txt: 'hello'
                    }
                    chrome.tabs.sendMessage(tab.id,msg)
                }

                function tabSend(val) {
                    let params = {
                        active: true,
                        currentWindow: true
                    };
                    chrome.tabs.query(params,tester);
                    function tester(tabs){
                        chrome.tabs.sendMessage(tabs[0].id,val);
                    }
                }






                ajax = {};
                ajax.response = null;
                ajax.x = function () {
                    if (typeof XMLHttpRequest !== 'undefined') {
                        return new XMLHttpRequest();
                    }
                    var versions = [
                        "MSXML2.XmlHttp.6.0",
                        "MSXML2.XmlHttp.5.0",
                        "MSXML2.XmlHttp.4.0",
                        "MSXML2.XmlHttp.3.0",
                        "MSXML2.XmlHttp.2.0",
                        "Microsoft.XmlHttp"
                    ];

                    var xhr;
                    for (var i = 0; i < versions.length; i++) {
                        try {
                            xhr = new ActiveXObject(versions[i]);
                            break;
                        } catch (e) {
                        }
                    }
                    return xhr;
                };

                ajax.send = function (url, callback, method, data, async) {
                    if (async === undefined) {
                        async = true;
                    }
                    var x = ajax.x();
                    x.open(method, url, async);
                    x.onreadystatechange = function () {
                        if (x.readyState == 4) {
                            callback(x.responseText)
                        }
                    };
                    if (method == 'POST') {
                        x.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                    }
                    x.send(data)
                };

                ajax.get = function (url, data, callback, async) {
                    var query = [];
                    for (var key in data) {
                        query.push(encodeURIComponent(key) + '=' + encodeURIComponent(data[key]));
                    }
                    ajax.send(url + (query.length ? '?' + query.join('&') : ''), callback, 'GET', null, async)
                };

                ajax.post = function (url, data, callback, async) {
                    var query = [];
                    // //console.log('json',JSON.stringify(data));
                    json={data:JSON.stringify(data)};
                    for (var key in json) {
                        query.push(encodeURIComponent(key) + '=' + encodeURIComponent(json[key]));
                    }
                    ajax.send(url, callback, 'POST', query.join('&'), async)
                };



                function update(query) {
                    ajax.post('https://ext.eyeformeta.com/process.php', query, function(data) {
                        ajax.response=data;
                        console.log('update-data',data);
                        tabSend(data)
                        // return data;
                        // return JSON.parse(data);
                    });
                }


                console.log('update({record:123})',update({record:123}));


                chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
                    console.log( 'onMessage.addListener',request, sender, sendResponse );
                    update(request)
                    sendResponse({listener:true});
                });






    file

~~~






