<?php

// animate-beetle-guarded08@
$correct_pin = 'faa0a1acacee3e254d66575078427fb0';

require_once 'fn.php';

// Create a new FileDatabase object with the name of your SQLite database file
$db = new FileDatabase('database.db');

// Read the file path from 'path.txt'
$file_path = trim(file_get_contents('path.txt'));


function savePinToCookie($pin) {
  // Set the cookie to expire in 10 years
  $expiry = time() + (10 * 365 * 24 * 60 * 60);

  // Save the PIN in the cookie
  setcookie('pin', $pin, $expiry, '/');
}

function checkCookiePin() {
  // Check if a cookie with the name 'pin' exists
  if (isset($_COOKIE['pin'])) {
    // Get the PIN from the cookie
    $pin = $_COOKIE['pin'];

    // Check if the PIN is correct
    // $correct_pin = '1234';
    global $correct_pin;
    if ($pin === $correct_pin) {
      return true;
    }
  }

  return false;
}



// Check if the PIN was submitted
$pin = '';
if (isset($_POST['pin'])) {
  $pin = md5($_POST['pin']);
  savePinToCookie($pin);
}

// Check if the PIN is correct
if ($pin === $correct_pin || checkCookiePin()) {
  // Handle adding URLs
  if (isset($_POST['add_url']) && !empty($_POST['add_url'])) {
    $url = $_POST['add_url'];
    $db->addUrl($file_path, $url);
  }

  // Handle removing URLs
  if (isset($_POST['remove_url']) && !empty($_POST['remove_url'])) {
    $url = $_POST['remove_url'];
    $db->removeUrl($file_path, $url);
  }

  // Handle adding hashtags
  if (isset($_POST['add_hashtag']) && !empty($_POST['add_hashtag'])) {
    $hashtag = $_POST['add_hashtag'];
    $db->addHashtag($file_path, $hashtag);
  }

  // Handle removing hashtags
  if (isset($_POST['remove_hashtag']) && !empty($_POST['remove_hashtag'])) {
    $hashtag = $_POST['remove_hashtag'];
    $db->removeHashtag($file_path, $hashtag);
  }

  // Get the record for the specified file path
  $record = $db->getRecord($file_path);

  // Print the record to the screen
  if ($record !== false) {
    $urls = implode(', ', $record['urls']);
    $hashtags = implode(', ', $record['hashtags']);
    echo "File path: {$record['file_path']}<br>";
    echo "URLs: $urls<br>";
    echo "Hashtags: $hashtags<br>";

    // Display the form to add URLs and hashtags
    echo '<h3>Add URLs and hashtags</h3>';
    echo '<form method="post">';
    echo '<label for="add_url">Add URL:</label>';
    echo '<input type="text" id="add_url" name="add_url">';
    echo '<input type="submit" value="Add URL">';
    echo '</form>';

    echo '<form method="post">';
    echo '<label for="add_hashtag">Add hashtag:</label>';
    echo '<input type="text" id="add_hashtag" name="add_hashtag">';
    echo '<input type="submit" value="Add hashtag">';
    echo '</form>';

    // Display the form to remove URLs and hashtags
    echo '<h3>Remove URLs and hashtags</h3>';
    echo '<form method="post">';
    echo '<label for="remove_url">Remove URL:</label>';
    echo '<input type="text" id="remove_url" name="remove_url">';
    echo '<input type="submit" value="Remove URL">';
    echo '</form>';

    echo '<form method="post">';
    echo '<label for="remove_hashtag">Remove hashtag:</label>';
    echo '<input type="text" id="remove_hashtag" name="remove_hashtag">';
    echo '<input type="submit" value="Remove hashtag">';
    echo '</form>';
  } else {
    echo "Record not found for file path $file_path";
  }
  } else {
    // Display the PIN entry form
    echo '<form method="post">';
    echo '<label for="pin">Enter PIN:</label>';
    echo '<input type="password" id="pin" name="pin">';
    echo '<input type="submit" value="Submit">';
    echo '</form>';
  }
?>
