<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

class Projects {
  private $db;

  public function __construct($dbname) {
    $this->db = new SQLite3($dbname);
    $this->db->exec('CREATE TABLE IF NOT EXISTS projects (project TEXT PRIMARY KEY, description TEXT, files TEXT, urls TEXT, hashtags TEXT)');
  }

  public function projectExists($project) {
    // Check if the project exists in the database
    $stmt = $this->db->prepare('SELECT COUNT(*) as count FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $count = $row['count'];
    $result->finalize();
    $stmt->close();

    return ($count > 0);
  }

  public function createProject($project) {
    // Add the project to the database
    $stmt = $this->db->prepare('INSERT INTO projects (project, files, urls, hashtags) VALUES (:project, :files, :urls, :hashtags)');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->bindValue(':files', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':urls', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':hashtags', '[]', SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function getPathFiles($project, $path) {
    // Get the files for the path in the project
    $stmt = $this->db->prepare('SELECT files FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $files = $row['files'];
    $result->finalize();
    $stmt->close();

    // Decode the files JSON string and return the array for the path
    $files_arr = json_decode($files, true);
    if (isset($files_arr[$path])) {
      return $files_arr[$path];
    } else {
      return [];
    }
  }

  public function addPathFile($project, $path, $file) {
    // Get the files for the path in the project
    $stmt = $this->db->prepare('SELECT files FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $files = $row['files'];
    $result->finalize();
    $stmt->close();

    // Decode the files JSON string and add the file to the array for the path
    $files_arr = json_decode($files, true);
    if (!isset($files_arr[$path])) {
      $files_arr[$path] = [];
    }
    if (!in_array($file, $files_arr[$path])) {
      $files_arr[$path][] = $file;

      // Update the record in the database
      $files_json = json_encode($files_arr);
      $stmt = $this->db->prepare('UPDATE projects SET files = :files WHERE project = :project');
      $stmt->bindValue(':files', $files_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function addUrl($project, $url) {
    // Get the urls for the project
    $stmt = $this->db->prepare('SELECT urls FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $urls = $row['urls'];
    $result->finalize();
    $stmt->close();

    // Decode the urls JSON string and add the url to the array
    $urls_arr = json_decode($urls, true);
    if (!in_array($url, $urls_arr)) {
      $urls_arr[] = $url;

      // Update the record in the database
      $urls_json = json_encode($urls_arr);
      $stmt = $this->db->prepare('UPDATE projects SET urls = :urls WHERE project = :project');
      $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function addHashtag($project, $hashtag) {
    // Get the hashtags for the project
    $stmt = $this->db->prepare('SELECT hashtags FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $hashtags = $row['hashtags'];
    $result->finalize();
    $stmt->close();

    // Decode the hashtags JSON string and add the hashtag to the array
    $hashtags_arr = json_decode($hashtags, true);
    if (!in_array($hashtag, $hashtags_arr)) {
      $hashtags_arr[] = $hashtag;

      // Update the record in the database
      $hashtags_json = json_encode($hashtags_arr);
      $stmt = $this->db->prepare('UPDATE projects SET hashtags = :hashtags WHERE project = :project');
      $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function deleteProject($project) {
    // Delete the project from the database
    $stmt = $this->db->prepare('DELETE FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function deletePath($project, $path) {
    // Get the files for the project
    $stmt = $this->db->prepare('SELECT files FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $files = $row['files'];
    $result->finalize();
    $stmt->close();

    // Decode the files JSON string and remove the path
    $files_arr = json_decode($files, true);
    if (($key = array_search($path, $files_arr)) !== false) {
      unset($files_arr[$key]);
      $files_arr = array_values($files_arr);

      // Update the record in the database
      $files_json = json_encode($files_arr);
      $stmt = $this->db->prepare('UPDATE projects SET files = :files WHERE project = :project');
      $stmt->bindValue(':files', $files_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function deleteAllPaths($project) {
    // Delete all paths for the project from the database
    $stmt = $this->db->prepare('UPDATE projects SET files = :files WHERE project = :project');
    $stmt->bindValue(':files', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function deleteUrl($project, $url) {
    // Get the urls for the project
    $stmt = $this->db->prepare('SELECT urls FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $urls = $row['urls'];
    $result->finalize();
    $stmt->close();

    // Decode the urls JSON string and remove the url
    $urls_arr = json_decode($urls, true);
    if (($key = array_search($url, $urls_arr)) !== false) {
      unset($urls_arr[$key]);
      $urls_arr = array_values($urls_arr);

      // Update the record in the database
      $urls_json = json_encode($urls_arr);
      $stmt = $this->db->prepare('UPDATE projects SET urls = :urls WHERE project = :project');
      $stmt->bindValue(':urls', $urls_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function deleteAllUrls($project) {
    // Delete all urls for the project from the database
    $stmt = $this->db->prepare('UPDATE projects SET urls = :urls WHERE project = :project');
    $stmt->bindValue(':urls', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function deleteHashtag($project, $hashtag) {
    // Get the hashtags for the project
    $stmt = $this->db->prepare('SELECT hashtags FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $hashtags = $row['hashtags'];
    $result->finalize();
    $stmt->close();

    // Decode the hashtags JSON string and remove the hashtag
    $hashtags_arr = json_decode($hashtags, true);
    if (($key = array_search($hashtag, $hashtags_arr)) !== false) {
      unset($hashtags_arr[$key]);
      $hashtags_arr = array_values($hashtags_arr);

      // Update the record in the database
      $hashtags_json = json_encode($hashtags_arr);
      $stmt = $this->db->prepare('UPDATE projects SET hashtags = :hashtags WHERE project = :project');
      $stmt->bindValue(':hashtags', $hashtags_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
  }

  public function deleteAllHashtags($project) {
    // Delete all hashtags for the project from the database
    $stmt = $this->db->prepare('UPDATE projects SET hashtags = :hashtags WHERE project = :project');
    $stmt->bindValue(':hashtags', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function projectExists2($project) {
    // Check if the project exists in the database
    $stmt = $this->db->prepare('SELECT 1 FROM projects WHERE project = :project LIMIT 1');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_NUM);
    $result->finalize();
    $stmt->close();
    return $row != null;
  }

  public function createProject2($project) {
    // Create the project in the database
    $stmt = $this->db->prepare('INSERT INTO projects (project, files, urls, hashtags) VALUES (:project, :files, :urls, :hashtags)');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->bindValue(':files', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':urls', '[]', SQLITE3_TEXT);
    $stmt->bindValue(':hashtags', '[]', SQLITE3_TEXT);
    $stmt->execute();
    $stmt->close();
  }

  public function pathExists($project, $path) {
    // Check if the path exists in the database for the project
    $stmt = $this->db->prepare('SELECT 1 FROM projects WHERE project = :project AND JSON_EXTRACT(files, :path) IS NOT NULL LIMIT 1');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $stmt->bindValue(':path', '$."' . $path . '"', SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_NUM);
    $result->finalize();
    $stmt->close();
    return $row != null;
  }

  public function addPath($project, $path) {
    // Get the files for the project
    $stmt = $this->db->prepare('SELECT files FROM projects WHERE project = :project');
    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
    $result = $stmt->execute();
    $row = $result->fetchArray(SQLITE3_ASSOC);
    $files = $row['files'];
    $result->finalize();
    $stmt->close();

    // Decode the files JSON string and add the path
    $files_arr = json_decode($files, true);
    if (!in_array($path, $files_arr)) {
      $files_arr[] = $path;

      // Update the record in the database
      $files_json = json_encode($files_arr);
      $stmt = $this->db->prepare('UPDATE projects SET files = :files WHERE project = :project');
      $stmt->bindValue(':files', $files_json, SQLITE3_TEXT);
      $stmt->bindValue(':project', $project, SQLITE3_TEXT);
      $stmt->execute();
      $stmt->close();
    }
    }

	public function updateProjectDescription($project, $description) {
	    $stmt = $this->db->prepare('UPDATE projects SET description = :description WHERE project = :project');
	    $stmt->bindValue(':description', $description, SQLITE3_TEXT);
	    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
	    $stmt->execute();
	    $stmt->close();
	}
	public function viewProject($project) {
	    // Get the project details from the database
	    $stmt = $this->db->prepare('SELECT * FROM projects WHERE project = :project');
	    $stmt->bindValue(':project', $project, SQLITE3_TEXT);
	    $result = $stmt->execute();
	    $row = $result->fetchArray(SQLITE3_ASSOC);
	    $result->finalize();
	    $stmt->close();

	    // Check if the project exists
	    if (!$row) {
	        return null;
	    }

	    // Format the project details nicely
	    $formatted = array(
	        'Project' => $row['project'],
	        'Description' => $row['description'],
	        'Files' => json_decode($row['files'], true),
	        'URLs' => json_decode($row['urls'], true),
	        'Hashtags' => json_decode($row['hashtags'], true)
	    );

	    return $formatted;
	}


  }


?>