<?php
include_once('fn.php');

$projects = new Projects('projects.db');

// Check for new hashtag, url, or path from POST request and add to the database
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  $project = $_POST['project'];
  if (!$projects->projectExists($project)) {
    $projects->createProject($project);
  }

  if (isset($_POST['description'])) {
    $projects->updateProjectDescription($project, $_POST['description']);
  }

  if (isset($_POST['hashtags'])) {
    $hashtags = explode(',', $_POST['hashtags']);
    foreach ($hashtags as $hashtag) {
      $projects->addHashtag($project, trim($hashtag));
    }
  }

  if (isset($_POST['url'])) {
    $projects->addUrl($project, $_POST['url']);
  }

  if (isset($_POST['path'])) {
    $projects->addPath($project, $_POST['path']);
  }
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Add Project Data</title>
</head>
<body>
  <h1>Add Project Data</h1>
  <form method="post">
    <label for="project">Project:</label>
    <input type="text" name="project" required><br>

    <label for="description">Description:</label>
    <textarea name="description"></textarea>
    <br>

    <label for="hashtags">Hashtags (comma delimited):</label>
    <input type="text" name="hashtags"><br>

    <label for="url">URL:</label>
    <input type="text" name="url"><br>

    <label for="path">Path:</label>
    <input type="text" name="path"><br>

    <input type="submit" value="Add Data">
  </form>
</body>
</html>
