<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

require_once 'fn.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  // Get the project name from the form data
  $project = $_POST['project'];

  // Create an instance of the Projects class
  $db = new Projects('projects.db');

  // Add the path, url, and hashtag to the project
  $path = $_POST['path'];
  $file = $_POST['file'];
  $db->addPathFile($project, $path, $file);

  $url = $_POST['url'];
  $db->addUrl($project, $url);

  $hashtags = explode(',', $_POST['hashtags']);
  foreach ($hashtags as $hashtag) {
    $db->addHashtag($project, trim($hashtag));
  }
}

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
  // Get the project name from the URL parameter
  $project = $_GET['project'];

  // Create an instance of the Projects class
  $db = new Projects('projects.db');

  // Get the files for the path in the project
  $path = $_GET['path'];
  $files = $db->getPathFiles($project, $path);

  // Output the files as JSON
  header('Content-Type: application/json');
  echo json_encode($files);
}
?>
