<?php
include_once('AppManager.php');
$appManager = new AppManager('.', 'R2D2_C3P0');
$appId = $_GET['id'];
$memberId = $_GET['member_id'];

// Read the app info and access data
$appInfo = $appManager->readJson("apps/$appId/info.json");
$currentAccess = $appManager->getAppAccess($memberId, $appId);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $access = $_POST['access'];
    $appManager->setAppAccess($memberId, $appId, $access);
    header("Location: app_edit.php?id=$appId&member_id=$memberId");
    exit();
}

// Get lists of files, folders, and GET parameters for the member and app
$getParameters = $appManager->appGetList($memberId, $appId);
$files = $appManager->fileList($memberId, $appId);
$folders = $appManager->folderList($memberId, $appId);

// Debugging: Log data
error_log("App ID: $appId, Member ID: $memberId");
error_log("App Info: " . json_encode($appInfo));
error_log("Current Access: " . json_encode($currentAccess));
error_log("GET Parameters: " . json_encode($getParameters));
error_log("Files: " . json_encode($files));
error_log("Folders: " . json_encode($folders));

$accessOptions = ['admin', 'view', 'add', 'modify', 'move', 'edit', 'dir', 'checklist', 'delete', 'php'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit App</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-app.php'); ?>
    <div class="container">
        <h2>Edit App</h2>
        <form method="POST">
            <div class="form-group">
                <label for="url">URL:</label>
                <input type="text" class="form-control" id="url" name="url" value="<?php echo htmlspecialchars($appInfo['url']); ?>" readonly>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <?php foreach ($accessOptions as $option): ?>
                        <option value="<?php echo $option; ?>" <?php echo in_array($option, $currentAccess) ? 'selected' : ''; ?>><?php echo ucfirst($option); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>

        <h3>GET Parameters</h3>
        <a href="app_get_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add GET Parameter</a>
        <ul>
            <?php if (empty($getParameters)): ?>
                <li>No GET parameters found.</li>
            <?php else: ?>
                <?php foreach ($getParameters as $parameter): ?>
                    <li>
                        <?php echo htmlspecialchars($parameter['key'] . ' => ' . $parameter['value']); ?>
                        <a href="app_get_edit.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>&key=<?php echo urlencode($parameter['key']); ?>&value=<?php echo urlencode($parameter['value']); ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <a href="app_get_remove.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>&key=<?php echo urlencode($parameter['key']); ?>&value=<?php echo urlencode($parameter['value']); ?>" class="btn btn-sm btn-danger">Remove</a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

        <h3>Folders</h3>
        <a href="folder_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add Folder</a>
        <ul>
            <?php if (empty($folders)): ?>
                <li>No folders found.</li>
            <?php else: ?>
                <?php foreach ($folders as $folder): ?>
                    <?php
                    $folderId = pathinfo($folder['path'], PATHINFO_FILENAME); // Remove the .json extension
                    ?>
                    <li>
                        <a href="folder_edit.php?member_id=<?php echo $memberId; ?>&folder_id=<?php echo $folderId; ?>"><?php echo htmlspecialchars($folder['path']); ?></a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

        <h3>Files</h3>
        <a href="file_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add File</a>
        <ul>
            <?php if (empty($files)): ?>
                <li>No files found.</li>
            <?php else: ?>
                <?php foreach ($files as $file): ?>
                    <?php
                    $fileId = pathinfo($file['path'], PATHINFO_FILENAME); // Remove the .json extension
                    ?>
                    <li>
                        <a href="file_edit.php?member_id=<?php echo $memberId; ?>&file_id=<?php echo $fileId; ?>"><?php echo htmlspecialchars($file['path']); ?></a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>
</body>
</html>
