<?php
include_once('AppManager.php');
$appManager = new AppManager('.', 'R2D2_C3P0');
$appId = $_GET['app_id'];
$memberId = $_GET['member_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $folderPath = $_POST['folder_path'];
    $access = $_POST['access'];
    $appManager->addFolder($memberId, $appId, $folderPath, $access);
    header("Location: app_edit.php?id=$appId&member_id=$memberId");
    exit();
}

$accessOptions = ['admin', 'view', 'add', 'modify', 'move', 'edit', 'dir', 'checklist', 'delete', 'php'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Add Folder</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Add Folder</h2>
        <form method="POST">
            <div class="form-group">
                <label for="folder_path">Folder Path:</label>
                <input type="text" class="form-control" id="folder_path" name="folder_path" required>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <?php foreach ($accessOptions as $option): ?>
                        <option value="<?php echo $option; ?>"><?php echo ucfirst($option); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Add Folder</button>
        </form>
    </div>
</body>
</html>
`