<?php
include_once('AppManager.php');
$appManager = new AppManager('.', 'R2D2_C3P0');
$memberId = $_GET['member_id'];
$folderId = $_GET['folder_id'];
$appId = $appManager->appSearch($memberId,$folderId);

$folderInfo = $appManager->readJson("members/$memberId/apps/$appId/folders/$folderId.json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $path = $_POST['path'];
    $access = implode(',', $_POST['access']);
    $folderInfo['path'] = $path;
    $folderInfo['access'] = $appManager->inflateAccess($access);
    $appManager->writeJson("members/$memberId/apps/$appId/folders/$folderId.json", $folderInfo);
    header("Location: member_edit.php?id=$memberId");
    exit();
}
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Folder</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Edit Folder</h2>
        <form method="POST">
            <div class="form-group">
                <label for="path">Path:</label>
                <input type="text" class="form-control" id="path" name="path" value="<?php echo htmlspecialchars($folderInfo['path']); ?>" required>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <option value="admin" <?php echo in_array('admin', $folderInfo['access']) ? 'selected' : ''; ?>>Admin</option>
                    <option value="view" <?php echo in_array('view', $folderInfo['access']) ? 'selected' : ''; ?>>View</option>
                    <option value="add" <?php echo in_array('add', $folderInfo['access']) ? 'selected' : ''; ?>>Add</option>
                    <option value="modify" <?php echo in_array('modify', $folderInfo['access']) ? 'selected' : ''; ?>>Modify</option>
                    <option value="move" <?php echo in_array('move', $folderInfo['access']) ? 'selected' : ''; ?>>Move</option>
                    <option value="edit" <?php echo in_array('edit', $folderInfo['access']) ? 'selected' : ''; ?>>Edit</option>
                    <option value="dir" <?php echo in_array('dir', $folderInfo['access']) ? 'selected' : ''; ?>>Dir</option>
                    <option value="checklist" <?php echo in_array('checklist', $folderInfo['access']) ? 'selected' : ''; ?>>Checklist</option>
                    <option value="delete" <?php echo in_array('delete', $folderInfo['access']) ? 'selected' : ''; ?>>Delete</option>
                    <option value="php" <?php echo in_array('php', $folderInfo['access']) ? 'selected' : ''; ?>>PHP</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</body>
</html>
