<?php
include_once('AppManager.php');
$appManager = new AppManager('.', 'R2D2_C3P0');
$memberId = $_GET['id'];
$memberInfo = $appManager->readJson("members/$memberId/who.json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $updatedInfo = [
        "nickname" => $_POST['nickname'],
        "first" => $_POST['first'],
        "last" => $_POST['last'],
        "email" => $_POST['email'],
        "phone" => $_POST['phone']
    ];
    $appManager->addMember($updatedInfo);
    header("Location: member_list.php");
    exit();
}

$apps = $appManager->appList();
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Member</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Edit Member</h2>
        <form method="POST">
            <div class="form-group">
                <label for="nickname">Nickname:</label>
                <input type="text" class="form-control" id="nickname" name="nickname" value="<?php echo htmlspecialchars($memberInfo['nickname']); ?>" required>
            </div>
            <div class="form-group">
                <label for="first">First Name:</label>
                <input type="text" class="form-control" id="first" name="first" value="<?php echo htmlspecialchars($memberInfo['first']); ?>" required>
            </div>
            <div class="form-group">
                <label for="last">Last Name:</label>
                <input type="text" class="form-control" id="last" name="last" value="<?php echo htmlspecialchars($memberInfo['last']); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($memberInfo['email']); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Phone:</label>
                <input type="text" class="form-control" id="phone" name="phone" value="<?php echo htmlspecialchars($memberInfo['phone']); ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>

        <h3>Apps</h3>
        <a href="member_add_app.php?member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add App URL</a>
        <ul>
            <?php foreach ($apps as $appId => $url): ?>
                <li><a href="app_edit.php?id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>"><?php echo htmlspecialchars($url); ?></a></li>
            <?php endforeach; ?>
        </ul>
    </div>
</body>
</html>
