<?php
include_once('AppManager.php');
$appManager = new AppManager('.', 'R2D2_C3P0');
$members = scandir('./members');

?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Member List</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    <div class="container">
        <h2>Member List</h2>
        <a href="member_add.php" class="btn btn-primary">Add Member</a>
        <table class="table">
            <thead>
                <tr>
                    <th>Nickname</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($members as $memberId): ?>
                    <?php if ($memberId === '.' || $memberId === '..') continue; ?>
                    <?php $memberInfo = $appManager->readJson("members/$memberId/who.json"); ?>
                    <tr>
                        <td><?php echo htmlspecialchars($memberInfo['nickname']); ?></td>
                        <td><?php echo htmlspecialchars($memberInfo['first']); ?></td>
                        <td><?php echo htmlspecialchars($memberInfo['last']); ?></td>
                        <td><?php echo htmlspecialchars($memberInfo['email']); ?></td>
                        <td><?php echo htmlspecialchars($memberInfo['phone']); ?></td>
                        <td>
                            <a href="member_edit.php?id=<?php echo $memberId; ?>" class="btn btn-warning">Edit</a>
                            <a href="member_delete.php?id=<?php echo $memberId; ?>" class="btn btn-danger">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-app.php'); ?>
</body>
</html>
