<?php
include_once 'head.php';
$appId = $_GET['id'];
$memberId = $_GET['member_id'];

// Read the app info and access data
$appInfo = $appManager->readJson("apps/$appId/info.json");
// print_r($appInfo);
$currentAccess = $appManager->getAppAccess($memberId, $appId);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $access = $_POST['access'];
    $appManager->setAppAccess($memberId, $appId, $access);
    header("Location: app_edit.php?id=$appId&member_id=$memberId");
    exit();
}

// Get lists of files, folders, and GET parameters for the member and app
$getParameters = $appManager->appGetList($memberId, $appId);
$files = $appManager->fileList($memberId, $appId);
$folders = $appManager->folderList($memberId, $appId);

$accessOptions = ['admin', 'view', 'add', 'modify', 'move', 'edit', 'dir', 'checklist', 'delete', 'php'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage App</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
    <style>
        .modal-dialog {
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
            max-width: 100%;
        }

        .modal-content {
            height: 100%;
            border: 0;
            border-radius: 0;
        }

        .modal-body {
            height: 100%;
            padding: 0;
        }

        #modalIframe {
            width: 100%;
            height: calc(100vh - 100px); /* Adjust height to take full viewport minus modal header/footer */
            border: none; /* Optional: remove border */
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Manage App</h2>
        <form method="POST">
            <div class="form-group">
                <label for="url">URL:</label>
                <input type="text" class="form-control" id="url" name="url" value="<?php echo htmlspecialchars($appInfo['url']); ?>" disabled="disabled">
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <?php foreach ($accessOptions as $option): ?>
                        <option value="<?php echo $option; ?>" <?php echo in_array($option, $currentAccess) ? 'selected' : ''; ?>><?php echo ucfirst($option); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>

        <h3>GET Parameters</h3>
        <a href="#" data-toggle="modal" data-target="#modal" data-remote="app_get_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add GET Parameter</a>
        <ul>
            <?php if (empty($getParameters)): ?>
                <li>No GET parameters found.</li>
            <?php else: ?>
                <?php foreach ($getParameters as $parameter): ?>
                    <li>
                        <?php echo htmlspecialchars($parameter['key'] . ' => ' . $parameter['value']); ?>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="app_get_edit.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>&key=<?php echo urlencode($parameter['key']); ?>&value=<?php echo urlencode($parameter['value']); ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="app_get_remove.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>&key=<?php echo urlencode($parameter['key']); ?>&value=<?php echo urlencode($parameter['value']); ?>" class="btn btn-sm btn-danger">Remove</a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

        <h3>Folders</h3>
        <a href="#" data-toggle="modal" data-target="#modal" data-remote="folder_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add Folder</a>
        <ul>
            <?php if (empty($folders)): ?>
                <li>No folders found.</li>
            <?php else: ?>
                <?php foreach ($folders as $folder): ?>
                    <?php
                    $folderId = $appManager->getFolderId($folder['path']);
                    ?>
                    <li>
                        <?php echo htmlspecialchars($folder['path']); ?>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="folder_edit.php?member_id=<?php echo $memberId; ?>&folder_id=<?php echo $folderId; ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="folder_remove.php?member_id=<?php echo $memberId; ?>&folder_id=<?php echo $folderId; ?>" class="btn btn-sm btn-danger">Remove</a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

        <h3>Files</h3>
        <a href="#" data-toggle="modal" data-target="#modal" data-remote="file_add.php?app_id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-primary">Add File</a>
        <ul>
            <?php if (empty($files)): ?>
                <li>No files found.</li>
            <?php else: ?>
                <?php foreach ($files as $file): ?>
                    <?php
                    $fileId = $appManager->getFileId($file['path']);
                    ?>
                    <li>
                        <?php echo htmlspecialchars($file['path']); ?>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="file_edit.php?member_id=<?php echo $memberId; ?>&file_id=<?php echo $fileId; ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <a href="#" data-toggle="modal" data-target="#modal" data-remote="file_remove.php?member_id=<?php echo $memberId; ?>&file_id=<?php echo $fileId; ?>" class="btn btn-sm btn-danger">Remove</a>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">App</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <iframe id="modalIframe" width="100%" height="100%" frameborder="0"></iframe>
                </div>
            </div>
        </div>
    </div>

    <script>
        $('#modal').on('show.bs.modal', function (e) {
            var link = $(e.relatedTarget);
            var modal = $(this);
            var remote = link.data('remote');
            modal.find('#modalIframe').attr('src', remote);
        });

        $('#modal').on('hidden.bs.modal', function (e) {
            // Reset the iframe src to prevent retaining the previous page state
            $(this).find('#modalIframe').attr('src', '');
            location.reload();
        });
    </script>
</body>
</html>
