<?php
include_once 'head.php';
$appId = $_GET['app_id'];
$memberId = $_GET['member_id'];
$key = $_GET['key'];
$value = urldecode($_GET['value']); // Decode the URL-encoded value

// Generate the key-value ID
$keyValueId = md5($key . $value);

// Read the GET parameter JSON file
$getParameter = $appManager->readJson("members/$memberId/apps/$appId/get/$keyValueId.json");
$currentAccess = $appManager->getAppGetAccess($memberId, $appId, $key, $value);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newKey = $_POST['key'];
    $newValue = $_POST['value'];
    $access = $_POST['access'];
    $appManager->appGetAdd($memberId, $appId, $newKey, $newValue); // Update the GET parameter with new key and value
    if ($newKey !== $key || $newValue !== $value) {
        // Remove the old key-value pair if it was changed
        $appManager->appGetRemove($memberId, $appId, $key, $value);
    }
    $appManager->setAppGetAccess($memberId, $appId, $newKey, $newValue, $access); // Update the access
    // header("Location: app_edit.php?id=$appId&member_id=$memberId");
    header("Location: saved.php");
    exit();
}

$accessOptions = ['admin', 'view', 'add', 'modify', 'move', 'edit', 'dir', 'checklist', 'delete', 'php'];
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit GET Parameter</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Edit GET Parameter</h2>
        <form method="POST">
            <div class="form-group">
                <label for="key">Key:</label>
                <input type="text" class="form-control" id="key" name="key" value="<?php echo htmlspecialchars($key); ?>" required>
            </div>
            <div class="form-group">
                <label for="value">Value:</label>
                <input type="text" class="form-control" id="value" name="value" value="<?php echo htmlspecialchars($value); ?>" required>
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <?php foreach ($accessOptions as $option): ?>
                        <option value="<?php echo $option; ?>" <?php echo in_array($option, $currentAccess) ? 'selected' : ''; ?>><?php echo ucfirst($option); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Update GET Parameter</button>
        </form>
    </div>
</body>
</html>
