<?php
include_once 'head.php';
$memberId = $_GET['member_id'];
$fileId = $_GET['file_id'];

$appId = $appManager->appSearch($memberId, $fileId);

$fileInfo = $appManager->readJson("members/$memberId/apps/$appId/files/$fileId.json");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $path = $_POST['path'];
    $access = implode(',', $_POST['access']);
    $pin = $_POST['pin'];
    $newFileId = $appManager->generateMd5($path); // Use generateMd5 for new ID

    // Update file info
    $fileInfo['path'] = $path;
    $fileInfo['access'] = $appManager->inflateAccess($access);
    $fileInfo['pin'] = $pin;

    // If the ID has changed, rename the file
    if ($newFileId !== $fileId) {
        // Ensure new ID does not exist already
        if (!file_exists("members/$memberId/apps/$appId/files/$newFileId.json")) {
            // Rename the file
            rename("members/$memberId/apps/$appId/files/$fileId.json", "members/$memberId/apps/$appId/files/$newFileId.json");
            // Update $fileId to the new one
            $fileId = $newFileId;
        } else {
            // Handle case where the new ID already exists (optional)
            echo "Error: A file with the new ID already exists.";
            exit();
        }
    }

    // Save the updated info
    $appManager->writeJson("members/$memberId/apps/$appId/files/$fileId.json", $fileInfo);

    // header("Location: member_edit.php?id=$memberId");
    header("Location: saved.php");
    exit();
}
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit File</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    <div class="container">
        <h2>Edit File</h2>
        <form method="POST">
            <div class="form-group">
                <label for="path">Path:</label>
                <input type="text" class="form-control" id="path" name="path" value="<?php echo htmlspecialchars($fileInfo['path']); ?>" required>
            </div>
            <div class="form-group">
                <label for="pin">Pin:</label>
                <input type="text" class="form-control" id="pin" name="pin" value="<?php echo htmlspecialchars($fileInfo['pin']); ?>">
            </div>
            <div class="form-group">
                <label for="access">Access:</label>
                <select class="form-control" id="access" name="access[]" multiple style="height: 200px;">
                    <option value="admin" <?php echo in_array('admin', $fileInfo['access']) ? 'selected' : ''; ?>>Admin</option>
                    <option value="view" <?php echo in_array('view', $fileInfo['access']) ? 'selected' : ''; ?>>View</option>
                    <option value="add" <?php echo in_array('add', $fileInfo['access']) ? 'selected' : ''; ?>>Add</option>
                    <option value="modify" <?php echo in_array('modify', $fileInfo['access']) ? 'selected' : ''; ?>>Modify</option>
                    <option value="move" <?php echo in_array('move', $fileInfo['access']) ? 'selected' : ''; ?>>Move</option>
                    <option value="edit" <?php echo in_array('edit', $fileInfo['access']) ? 'selected' : ''; ?>>Edit</option>
                    <option value="dir" <?php echo in_array('dir', $fileInfo['access']) ? 'selected' : ''; ?>>Dir</option>
                    <option value="checklist" <?php echo in_array('checklist', $fileInfo['access']) ? 'selected' : ''; ?>>Checklist</option>
                    <option value="delete" <?php echo in_array('delete', $fileInfo['access']) ? 'selected' : ''; ?>>Delete</option>
                    <option value="php" <?php echo in_array('php', $fileInfo['access']) ? 'selected' : ''; ?>>PHP</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</body>
</html>
