<?php
include_once 'head.php';

$memberId = $_GET['member_id'];
$folderId = $_GET['folder_id'];
$appId = $appManager->appSearch($memberId, $folderId);

if ($appId) {
    $folderInfo = $appManager->readJson("members/$memberId/apps/$appId/folders/$folderId.json");
    if ($folderInfo) {
        $folderPath = $folderInfo['path'];
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $appManager->removeFolder($memberId, $appId, $folderPath);
            header("Location: saved.php");
            exit();
        }
    } else {
        echo "Folder not found or invalid.";
        exit();
    }
} else {
    echo "Folder not found or invalid.";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Remove Folder</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
</head>
<body>
    
    <div class="container">
        <h2>Remove Folder</h2>
        <form method="POST">
            <p>Are you sure you want to remove the folder "<?php echo htmlspecialchars($folderPath); ?>"?</p>
            <button type="submit" class="btn btn-danger">Remove</button>
            <a href="app_edit.php?id=<?php echo $appId; ?>&member_id=<?php echo $memberId; ?>" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</body>
</html>
