<?php
include_once 'head.php';
$members = scandir('./members');
?><!DOCTYPE html>
<html lang="en">
<head>
    <title>App Security Manager</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-header.php'); ?>
    <style>
        body {
            color: var(--text-color);
        }
        th, td {
            color: var(--text-color) !important;
        }

        .modal-dialog {
            width: 100%;
            height: 100%;
            margin: 0;
            padding: 0;
            max-width: 100%;
        }

        .modal-content {
            height: 100%;
            border: 0;
            border-radius: 0;
        }

        .modal-body {
            height: 100%;
            padding: 0;
        }

        #modalIframe {
            width: 100%;
            height: calc(100vh - 100px); /* Adjust height to take full viewport minus modal header/footer */
            border: none; /* Optional: remove border */
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Member List</h2>
        <a href="#" data-toggle="modal" data-target="#modal" data-remote="member_add.php" class="btn btn-primary">Add Member</a>
        <table class="table">
            <thead>
                <tr>
                    <th>Nickname</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($members as $memberId): ?>
                    <?php if ($memberId === '.' || $memberId === '..') continue; ?>
                    <?php $memberInfo = $appManager->readJson("members/$memberId/who.json"); ?>
                    <tr>
                        <td><?php echo htmlspecialchars($memberInfo['nickname']); ?></td>
                        <td>
                            <a href="#" data-toggle="modal" data-target="#modal" data-remote="member_edit.php?id=<?php echo $memberId; ?>" class="btn btn-warning" onclick="setSelectedMember('<?php echo htmlspecialchars($memberInfo['nickname']); ?>')">Manage</a>
                            <a href="#" data-toggle="modal" data-target="#modal" data-remote="member_delete.php?id=<?php echo $memberId; ?>" class="btn btn-danger" onclick="setSelectedMember('<?php echo htmlspecialchars($memberInfo['nickname']); ?>')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">Member: <span id="selectedMember"></span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <iframe id="modalIframe" width="100%" height="100%" frameborder="0"></iframe>
                </div>
            </div>
        </div>
    </div>

    <script>
        function setSelectedMember(nickname) {
            document.getElementById('selectedMember').textContent = nickname;
        }

        $('#modal').on('show.bs.modal', function (e) {
            var link = $(e.relatedTarget);
            var modal = $(this);
            var remote = link.data('remote');
            modal.find('#modalIframe').attr('src', remote);
        });

        $('#modal').on('hidden.bs.modal', function (e) {
            // Reset the iframe src to prevent retaining the previous page state
            $(this).find('#modalIframe').attr('src', '');
            location.reload();
        });
    </script>
    <?php include_once($_SERVER['DOCUMENT_ROOT'].'/.re/themes-app.php'); ?>
</body>
</html>
