<?php
// Fetch database credentials
function getDBCredentials() {
    $credentials = json_decode(file_get_contents('https://keys.sds.sh/?json=1&prefix=1&id=programmer-dnd-*'), true);
    return $credentials;
}


function idEn($id) {
    $id = (string)$id;
    include_once($_SERVER['DOCUMENT_ROOT'].'/.re/modules/ephemeralLinkManagerAES.php');
	$eph = new EphemeralLinkManager();
	return $eph->cryptEn($id,'c5960d3b0d31');
}

function idDe($en) {
    include_once($_SERVER['DOCUMENT_ROOT'].'/.re/modules/ephemeralLinkManagerAES.php');
	$eph = new EphemeralLinkManager();
	return $eph->cryptDe($en,'c5960d3b0d31');
}


// Establish database connection
function getDBConnection() {
    $credentials = getDBCredentials();
    $conn = new mysqli(
        $credentials['host'],
        $credentials['user'],
        $credentials['password'],
        $credentials['db']
    );

    if ($conn->connect_error) {
        die('Database connection failed: ' . $conn->connect_error);
    }
    return $conn;
}

// Process incoming requests via action
if (isset($_REQUEST['action'])) {
    $action = $_REQUEST['action'];

    header('Content-Type: application/json');

    try {
        switch ($action) {
            case 'login':
                login($_REQUEST);
                break;
            case 'create':
                createRecord($_REQUEST);
                break;
            case 'read':
                readRecords($_REQUEST);
                break;
            case 'update':
                updateRecord($_REQUEST);
                break;
            case 'delete':
                deleteRecord($_REQUEST);
                break;
            case 'getGameManagerProfiles':
                getGameManagerProfiles($_REQUEST);
                break;
            case 'createGameManagerProfile':
                createGameManagerProfile($_REQUEST);
                break;
            case 'createPlayer':
                createPlayer($_REQUEST);
                break;
            case 'readNameID':
                readNameID($_REQUEST);
                break;
    
            default:
                throw new Exception("Invalid action: $action");
        }
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
    }

    exit;
}

function readNameID($data) {
    $conn = getDBConnection();
    $table = $data['table'];
    $sql = "SELECT {$table}ID, Name FROM $table";

    $result = $conn->query($sql);
    $rows = [];
    while ($row = $result->fetch_assoc()) {
        $rows[] = $row;
    }

    $conn->close();
    echo json_encode($rows);
}

function createPlayer($data) {
    $conn = getDBConnection();
    if (isset($data['password'])) {
        if ($data['password'] !== $data['confirmPassword']) {
            echo json_encode(['error' => 'Passwords do not match.']);
            return;
        }
    }

    $hashedPassword = password_hash($data['password'], PASSWORD_DEFAULT);

    // Insert player
    $playerData = [
        'Name' => $data['name'],
        'Email' => $data['email'],
    ];
    if (isset($data['password'])) {
        $playerData['Password'] = $hashedPassword;
    }

    insert('Players', $playerData);

    // Insert Dungeon Master if selected
    if (!empty($data['isDungeonMaster']) && $data['isDungeonMaster'] === 'true') {
        $dmData = [
            'Name' => $data['name'],
            'Email' => $data['email'],
            'ExperienceLevel' => $data['experienceLevel']
        ];
        insert('DungeonMasters', $dmData);
    }

    echo json_encode(['success' => true]);
}

// Get Game Manager Profiles for a Dungeon Master
function getGameManagerProfiles($data) {
    $conn = getDBConnection();
    $dmId = $data['dmId'] ?? $data['DungeonMasterID'];
    $dmId = idDe($dmId);

    $sql = "SELECT * FROM GameManagerProfiles WHERE DungeonMasterID = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $dmId);
    $stmt->execute();
    $result = $stmt->get_result();

    $profiles = [];
    while ($row = $result->fetch_assoc()) {
        $row['GameManagerID'] = idEn($row['GameManagerID']);
        $profiles[] = $row;
    }

    $stmt->close();
    $conn->close();

    echo json_encode(['profiles' => $profiles]);
}

// Create a New Game Manager Profile
function createGameManagerProfile($data) {
    $conn = getDBConnection();
    $dmId = $data['dmId'] ?? $data['DungeonMasterID'];
    $dmId = idDe($dmId);
    $label = $data['label'];

    $sql = "INSERT INTO GameManagerProfiles (DungeonMasterID, Label) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $dmId, $label);

    if ($stmt->execute()) {
        $profileId = $stmt->insert_id;
        echo json_encode(['success' => true, 'profile' => ['GameManagerID' => $profileId, 'Label' => $label]]);
    } else {
        echo json_encode(['error' => $stmt->error]);
    }

    $stmt->close();
    $conn->close();
}


// Login function
function login($data) {
    $conn = getDBConnection();

    // Fetch player by email
    $sql = "SELECT * FROM Players WHERE Email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $data['email']);
    $stmt->execute();
    $player = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$player || !password_verify($data['password'], $player['Password'])) {
        echo json_encode(['error' => 'Invalid login credentials.']);
        return;
    }

    // Check if the player is also a Dungeon Master
    $sql = "SELECT * FROM DungeonMasters WHERE Email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $data['email']);
    $stmt->execute();
    $dm = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $conn->close();

    if ($dm) {
        echo json_encode(['success' => true, 'isDungeonMaster' => true, 'dungeonMasterID' => idEn($dm['DungeonMasterID'])]);
    } else {
        echo json_encode(['success' => true, 'isDungeonMaster' => false, 'playerID' => idEn($player['PlayerID'])]);
    }
}

// Create a record
function createRecord($data) {
    $conn = getDBConnection();
    $table = $data['table'];
    $record = $data['record'];


    




    insert($table, $record);
    echo json_encode(['success' => true]);
}

// Read records
function readRecords($data) {
    $conn = getDBConnection();
    $table = $data['table'];
    $sql = "SELECT * FROM $table";

    $result = $conn->query($sql);
    $rows = [];
    while ($row = $result->fetch_assoc()) {

        $rows[] = $row;
    }

    $conn->close();
    echo json_encode($rows);
}

// Update a record
function updateRecord($data) {
    $conn = getDBConnection();
    $table = $data['table'];
    $id = $data['id'];
    $record = $data['record'];

    foreach ($data as $key => $value) {
        $idKeys = [
            'CharacterID', 'SpellID', 'CampaignID', 'CharacterSpellID',
            'PlayerID', 'CharacterBattleID', 'InteractionID', 'GamePlayerID',
            'PlayerCharacterID', 'NarrativeID', 'StorylineID', 'DungeonMasterID',
            'ItemID', 'GameManagerID', 'BattleID', 'CharacterItemID', 'NPCID'
        ];
    
        if (in_array($key, $idKeys)) {
            if (!is_numeric($value) || (string)(int)$value !== $value) {
                $row[$key] = idEn($value);
            }
        }
    }

    $fields = implode(" = ?, ", array_keys($record)) . " = ?";
    $types = str_repeat('s', count($record)) . 'i';

    $sql = "UPDATE $table SET $fields WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $params = array_merge(array_values($record), [$id]);
    $stmt->bind_param($types, ...$params);

    if (!$stmt->execute()) {
        echo json_encode(['error' => $stmt->error]);
        return;
    }

    $stmt->close();
    $conn->close();
    echo json_encode(['success' => true]);
}

// Delete a record
function deleteRecord($data) {
    $conn = getDBConnection();
    $table = $data['table'];
    $id = idDe($data['id']);

    $sql = "DELETE FROM $table WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if (!$stmt->execute()) {
        echo json_encode(['error' => $stmt->error]);
        return;
    }

    $stmt->close();
    $conn->close();
    echo json_encode(['success' => true]);
}

// Insert a new record into a table
function insert($table, $data) {


    if (isset($data['CharacterID'])) { $data['CharacterID'] = idDe($data['CharacterID']); }
    if (isset($data['SpellID'])) { $data['SpellID'] = idDe($data['SpellID']); }
    if (isset($data['CampaignID'])) { $data['CampaignID'] = idDe($data['CampaignID']); }
    if (isset($data['CharacterSpellID'])) { $data['CharacterSpellID'] = idDe($data['CharacterSpellID']); }
    if (isset($data['PlayerID'])) { $data['PlayerID'] = idDe($data['PlayerID']); }
    if (isset($data['CharacterBattleID'])) { $data['CharacterBattleID'] = idDe($data['CharacterBattleID']); }
    if (isset($data['InteractionID'])) { $data['InteractionID'] = idDe($data['InteractionID']); }
    if (isset($data['GamePlayerID'])) { $data['GamePlayerID'] = idDe($data['GamePlayerID']); }
    if (isset($data['PlayerCharacterID'])) { $data['PlayerCharacterID'] = idDe($data['PlayerCharacterID']); }
    if (isset($data['NarrativeID'])) { $data['NarrativeID'] = idDe($data['NarrativeID']); }
    if (isset($data['StorylineID'])) { $data['StorylineID'] = idDe($data['StorylineID']); }
    if (isset($data['DungeonMasterID'])) { $data['DungeonMasterID'] = idDe($data['DungeonMasterID']); }
    if (isset($data['ItemID'])) { $data['ItemID'] = idDe($data['ItemID']); }
    if (isset($data['GameManagerID'])) { $data['GameManagerID'] = idDe($data['GameManagerID']); }
    if (isset($data['BattleID'])) { $data['BattleID'] = idDe($data['BattleID']); }
    if (isset($data['CharacterItemID'])) { $data['CharacterItemID'] = idDe($data['CharacterItemID']); }
    if (isset($data['NPCID'])) { $data['NPCID'] = idDe($data['NPCID']); }

    // foreach ($data as $key => $value) {
    //     $idKeys = [
    //         'CharacterID', 'SpellID', 'CampaignID', 'CharacterSpellID',
    //         'PlayerID', 'CharacterBattleID', 'InteractionID', 'GamePlayerID',
    //         'PlayerCharacterID', 'NarrativeID', 'StorylineID', 'DungeonMasterID',
    //         'ItemID', 'GameManagerID', 'BattleID', 'CharacterItemID', 'NPCID'
    //     ];
    
    //     if (in_array($key, $idKeys)) {
    //         if (!isset($data[$key])) {
    //             continue;
    //         }
    //         if (!is_numeric($value) || (string)(int)$value !== $value) {
    //             $row[$key] = idEn($value);
    //         }
    //     }
    // }
    // echo json_encode($data, JSON_PRETTY_PRINT); exit;
    // die(json_encode(['error' => $data['DungeonMasterID']]));
    $conn = getDBConnection();
    $fields = implode(", ", array_keys($data));
    $placeholders = implode(", ", array_fill(0, count($data), '?'));
    $types = str_repeat('s', count($data));

    $sql = "INSERT INTO $table ($fields) VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...array_values($data));

    if (!$stmt->execute()) {
        die(json_encode(['error' => $stmt->error]));
    }

    $stmt->close();
    $conn->close();
}
?>