<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-dark-5/dist/css/bootstrap-dark.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">Game Manager</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item"><a class="nav-link" href="#">Dashboard</a></li>
            </ul>
        </div>
    </div>
</nav>

<div class="container mt-4">
    <h1 class="text-center">Game Manager Profiles</h1>
    <div id="profileSelection" class="text-center">
        <h3>Select or Create a Game Manager Profile</h3>
        <div id="profilesList" class="mt-3"></div>
        <button class="btn btn-success mt-3" onclick="createNewProfile()">Create New Profile</button>
    </div>

    <div id="gameManagerContent" style="display: none;">
        <h3 id="currentProfileLabel" class="text-center"></h3>
        <button class="btn btn-primary" onclick="loadDashboard()">Go to Dashboard</button>
    </div>
</div>

<!-- Modal for Creating a New Profile -->
<div class="modal fade" id="createProfileModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New Game Manager Profile</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="createProfileForm">
                    <div class="mb-3">
                        <label for="profileLabel" class="form-label">Profile Label</label>
                        <input type="text" class="form-control" id="profileLabel" name="profileLabel" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveNewProfile()">Save</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        const email = sessionStorage.getItem('email'); // Assuming email is saved in sessionStorage after login

        if (!email) {
            alert('No email found. Redirecting to login.');
            window.location.href = 'login.html';
            return;
        }

        loadProfiles(email);
    });

    function loadProfiles(email) {
        $.ajax({
            url: 'functions.php',
            type: 'POST',
            data: { action: 'getGameManagerProfiles', email },
            success: function (response) {
                if (response.error) {
                    alert(response.error);
                    return;
                }

                const profiles = response.profiles;

                if (profiles.length === 0) {
                    $('#profilesList').html('<p>No profiles found. Please create a new profile.</p>');
                } else {
                    displayProfiles(profiles);
                }
            }
        });
    }

    function createNewProfile() {
        $('#createProfileModal').modal('show');
    }

    function saveNewProfile() {
        const email = sessionStorage.getItem('email');
        const label = $('#profileLabel').val();

        if (!label) {
            alert('Please provide a label for the profile.');
            return;
        }

        $.ajax({
            url: 'functions.php',
            type: 'POST',
            data: { action: 'createGameManagerProfile', email, label },
            success: function (response) {
                if (response.success) {
                    $('#createProfileModal').modal('hide');
                    loadProfiles(email);
                } else {
                    alert(response.error || 'Failed to create profile.');
                }
            }
        });
    }

    function displayProfiles(profiles) {
        const profilesList = $('#profilesList');
        profilesList.empty();

        profiles.forEach(profile => {
            const profileButton = $('<button></button>')
                .addClass('btn btn-secondary m-2')
                .text(profile.label)
                .click(() => selectProfile(profile));

            profilesList.append(profileButton);
        });
    }

    function selectProfile(profile) {
        sessionStorage.setItem('gameManagerID', profile.GameManagerID);
        sessionStorage.setItem('profileLabel', profile.label);
        $('#profileSelection').hide();
        $('#currentProfileLabel').text(`Current Profile: ${profile.label}`);
        $('#gameManagerContent').show();
    }

    function loadDashboard() {
        const gameManagerID = sessionStorage.getItem('gameManagerID');

        if (!gameManagerID) {
            alert('No profile selected. Redirecting to profile selection.');
            location.reload();
            return;
        }

        window.location.href = `game_manager_dashboard.php?gm=${gameManagerID}`;
    }
</script>
</body>
</html>
