<?php
include '../functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $campaign_id = $_POST['campaign_id'];
    $name = $_POST['name'];
    $description = $_POST['description'];
    $outcome = $_POST['outcome'];
    $date = $_POST['date'];

    // Check if CampaignID exists
    $campaign = fetchById('Campaigns', $campaign_id);
    if (!$campaign) {
        die("Error: Campaign with ID $campaign_id does not exist.");
    }

    insert('Battles', [
        'CampaignID' => $campaign_id,
        'Name' => $name,
        'Description' => $description,
        'Outcome' => $outcome,
        'Date' => $date
    ]);

    header('Location: read.php');
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="https://a.sds.sh/?f=css/fw.css&exec=[r=1,i:app.css][r=1,i:dnd.css]">
</head>
<body>
    <h2>Create Battle</h2>
    <form method="POST">
        <label>Campaign ID:</label>
        <input type="number" name="campaign_id" required>
        <label>Name:</label>
        <input type="text" name="name" required>
        <label>Description:</label>
        <textarea name="description"></textarea>
        <label>Outcome:</label>
        <input type="text" name="outcome">
        <label>Date:</label>
        <input type="date" name="date" required>
        <br>
        <button type="submit">Create</button>
    </form>
</body>
</html>
