<?php
include '../functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $player = $_POST['player'];
    $name = $_POST['name'];
    $class = ($_POST['class'] === 'Other') ? $_POST['custom_class'] : $_POST['class'];
    $level = $_POST['level'];
    $race = ($_POST['race'] === 'Other') ? $_POST['custom_race'] : $_POST['race'];
    $background = $_POST['background'];
    $player_id = $_POST['player_id'];
    $campaign_id = $_POST['campaign_id'];
    $health = $_POST['health'];
    $experience = $_POST['experience'];
    $alignment = $_POST['alignment'];

    // Validate PlayerID exists
    $player_exists = fetchById('Players', $player_id);
    if (!$player_exists) {
        die("Error: Player with ID $player_id does not exist.");
    }

    // Validate CampaignID exists
    if (!empty($campaign_id)) {
        $campaign_exists = fetchById('Campaigns', $campaign_id);
        if (!$campaign_exists) {
            die("Error: Campaign with ID $campaign_id does not exist.");
        }
    }

    // Insert the character into the database
    insert('Characters', [
        'Player' => $player,
        'Name' => $name,
        'Class' => $class,
        'Level' => $level,
        'Race' => $race,
        'Background' => $background,
        'PlayerID' => $player_id,
        'CampaignID' => $campaign_id,
        'Health' => $health,
        'Experience' => $experience,
        'Alignment' => $alignment
    ]);

    // Redirect to the read page after creation
    header('Location: read.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="https://a.sds.sh/?f=css/fw.css&exec=[r=1,i:app.css][r=1,i:dnd.css]">
    <title>Create Character</title>
</head>
<body>
    <h2>Create Character</h2>
    <form method="POST">
        <label for="player">Player:</label>
        <input type="text" name="player" id="player"> <!-- New field -->

        <label for="name">Name:</label>
        <input type="text" name="name" id="name" required>

        <label for="class">Class:</label>
        <select name="class" id="class" onchange="toggleCustomClass()" required>
            <option value="">Select a Class</option>
            <option value="Barbarian">Barbarian</option>
            <option value="Bard">Bard</option>
            <option value="Cleric">Cleric</option>
            <option value="Druid">Druid</option>
            <option value="Fighter">Fighter</option>
            <option value="Monk">Monk</option>
            <option value="Paladin">Paladin</option>
            <option value="Ranger">Ranger</option>
            <option value="Rogue">Rogue</option>
            <option value="Sorcerer">Sorcerer</option>
            <option value="Warlock">Warlock</option>
            <option value="Wizard">Wizard</option>
            <option value="Other">Other (Type Below)</option>
        </select>
        <input type="text" name="custom_class" id="custom_class" placeholder="Enter custom class" style="display:none;">

        <label for="level">Level:</label>
        <input type="number" name="level" id="level" required>

        <label for="race">Race:</label>
        <select name="race" id="race" onchange="toggleCustomRace()" required>
            <option value="">Select a Race</option>
            <option value="Dragonborn">Dragonborn</option>
            <option value="Dwarf">Dwarf</option>
            <option value="Elf">Elf</option>
            <option value="Gnome">Gnome</option>
            <option value="Half-Elf">Half-Elf</option>
            <option value="Halfling">Halfling</option>
            <option value="Half-Orc">Half-Orc</option>
            <option value="Human">Human</option>
            <option value="Tiefling">Tiefling</option>
            <option value="Other">Other (Type Below)</option>
        </select>
        <input type="text" name="custom_race" id="custom_race" placeholder="Enter custom race" style="display:none;">

        <label for="background">Background:</label>
        <input type="text" name="background" id="background">

        <label for="player_id">Player ID:</label>
        <input type="number" name="player_id" id="player_id" required>

        <label for="campaign_id">Campaign ID:</label>
        <input type="number" name="campaign_id" id="campaign_id">

        <label for="health">Health:</label>
        <input type="number" name="health" id="health" required>

        <label for="experience">Experience:</label>
        <input type="number" name="experience" id="experience">

        <label for="alignment">Alignment:</label>
        <input type="text" name="alignment" id="alignment">
        <br>
        <button type="submit">Create</button>
    </form>

    <script>
        // Show or hide custom class input based on dropdown selection
        function toggleCustomClass() {
            const classDropdown = document.getElementById('class');
            const customClassInput = document.getElementById('custom_class');
            if (classDropdown.value === 'Other') {
                customClassInput.style.display = 'block';
                customClassInput.required = true;
            } else {
                customClassInput.style.display = 'none';
                customClassInput.required = false;
            }
        }

        // Show or hide custom race input based on dropdown selection
        function toggleCustomRace() {
            const raceDropdown = document.getElementById('race');
            const customRaceInput = document.getElementById('custom_race');
            if (raceDropdown.value === 'Other') {
                customRaceInput.style.display = 'block';
                customRaceInput.required = true;
            } else {
                customRaceInput.style.display = 'none';
                customRaceInput.required = false;
            }
        }
    </script>
</body>
</html>
