<?php
include '../functions.php';
$characters = fetchAll('Characters');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="https://a.sds.sh/?f=css/fw.css&exec=[r=1,i:app.css][r=1,i:dnd.css]">
    <title>Characters</title>
</head>
<body>
    <h2>Characters</h2>
    <a href="create.php">Add Character</a>
    <table>
        <tr>
            <th>CharacterID</th>
            <th>Name</th>
            <th>Class</th>
            <th>Level</th>
            <th>Race</th>
            <th>Background</th>
            <th>Player ID</th>
            <th>Player</th> <!-- New field -->
            <th>Campaign ID</th>
            <th>Health</th>
            <th>Experience</th>
            <th>Alignment</th>
            <th>Actions</th>
        </tr>
        <?php foreach ($characters as $character): ?>
            <tr>
                <td><?= $character['CharacterID'] ?></td>
                <td><?= $character['Player'] ?></td> <!-- New field -->
                <td><?= $character['Name'] ?></td>
                <td><?= $character['Class'] ?></td>
                <td><?= $character['Level'] ?></td>
                <td><?= $character['Race'] ?></td>
                <td><?= $character['Background'] ?></td>
                <td><?= $character['PlayerID'] ?></td>
                <td><?= $character['CampaignID'] ?></td>
                <td><?= $character['Health'] ?></td>
                <td><?= $character['Experience'] ?></td>
                <td><?= $character['Alignment'] ?></td>
                <td>
                    <a href="update.php?id=<?= $character['CharacterID'] ?>">Edit</a> |
                    <a href="delete.php?id=<?= $character['CharacterID'] ?>">Delete</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
