<?php
// Database connection
function dbConnect() {
    // $credentials = parse_ini_file('credentials.ini');
    $credentials = json_decode(file_get_contents('https://keys.sds.sh/?json=1&prefix=1&id=dnd-characters-*'), true);
    $host = $credentials['host'];
    $dbname = $credentials['db'];
    $username = $credentials['user'];
    $password = $credentials['password'];
    try {
        return new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Enable exceptions for errors
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Default fetch mode
        ]);
    } catch (PDOException $e) {
        die("Database connection failed: " . $e->getMessage());
    }
}

// Create a new character
function createCharacter($data) {
    try {
        $db = dbConnect();
        $stmt = $db->prepare("INSERT INTO character_sheets (name, class_id, race_id, level, background_id) VALUES (:name, :class_id, :race_id, :level, :background_id)");
        $stmt->bindParam(':name', $data['name']);
        $stmt->bindParam(':class_id', $data['class_id']);
        $stmt->bindParam(':race_id', $data['race_id']);
        $stmt->bindParam(':level', $data['level']);
        $stmt->bindParam(':background_id', $data['background_id']);
        $stmt->execute();
        $db = null; // Close connection
        return true;
    } catch (PDOException $e) {
        error_log("Error creating character: " . $e->getMessage());
        return false;
    }
}

// Read all characters
function getCharacters() {
    try {
        $db = dbConnect();
        $stmt = $db->query("SELECT * FROM character_sheets");
        $result = $stmt->fetchAll();
        $db = null; // Close connection
        return $result;
    } catch (PDOException $e) {
        error_log("Error fetching characters: " . $e->getMessage());
        return [];
    }
}

// Read a single character
function getCharacter($id) {
    try {
        $db = dbConnect();
        $stmt = $db->prepare("SELECT * FROM character_sheets WHERE character_id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $result = $stmt->fetch();
        $db = null; // Close connection
        return $result;
    } catch (PDOException $e) {
        error_log("Error fetching character: " . $e->getMessage());
        return null;
    }
}

// Update a character
function updateCharacter($id, $data) {
    try {
        $db = dbConnect();
        $stmt = $db->prepare("UPDATE character_sheets SET name = :name, class_id = :class_id, race_id = :race_id, level = :level, background_id = :background_id WHERE character_id = :id");
        $stmt->bindParam(':name', $data['name']);
        $stmt->bindParam(':class_id', $data['class_id']);
        $stmt->bindParam(':race_id', $data['race_id']);
        $stmt->bindParam(':level', $data['level']);
        $stmt->bindParam(':background_id', $data['background_id']);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $db = null; // Close connection
        return true;
    } catch (PDOException $e) {
        error_log("Error updating character: " . $e->getMessage());
        return false;
    }
}

// Delete a character
function deleteCharacter($id) {
    try {
        $db = dbConnect();
        $stmt = $db->prepare("DELETE FROM character_sheets WHERE character_id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $db = null; // Close connection
        return true;
    } catch (PDOException $e) {
        error_log("Error deleting character: " . $e->getMessage());
        return false;
    }
}
?>
